/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimapIterator;
import org.redisson.RedissonMultiMapIterator;
import org.redisson.RedissonMultimap;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.listener.ListAddListener;
import org.redisson.api.listener.ListRemoveListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonListMultimap<K, V>
extends RedissonMultimap<K, V>
implements RListMultimap<K, V> {
    private static final RedisStrictCommand<Boolean> LLEN_VALUE = new RedisStrictCommand<Boolean>("LLEN", new BooleanAmountReplayConvertor());

    public RedissonListMultimap(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonListMultimap(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; size = size + redis.call('llen', name); end;end; return size; ", Arrays.asList(this.getRawName()), this.prefix);
    }

    @Override
    public RFuture<Long> fastRemoveValueAsync(V ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(this.prefix);
        this.encodeMapValues(args, Arrays.asList(values));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; for j = 2, #ARGV, 1 do size = size + redis.call('lrem', name, 1, ARGV[j]); end; end;end; return size; ", Arrays.asList(this.getRawName()), args.toArray());
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, LLEN_VALUE, setName);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        ByteBuf valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[2] .. v; local items = redis.call('lrange', name, 0, -1) for i=1,#items do if items[i] == ARGV[1] then return 1; end; end; end;end; return 0; ", Arrays.asList(this.getRawName()), valueState, this.prefix);
    }

    @Override
    public boolean containsEntry(Object key, Object value) {
        return this.get(this.containsEntryAsync(key, value));
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        ByteBuf valueState = this.encodeMapValue(value);
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local items = redis.call('lrange', KEYS[1], 0, -1) for i=1,#items do if items[i] == ARGV[1] then return 1; end; end; return 0; ", Collections.singletonList(setName), valueState);
    }

    @Override
    public boolean put(K key, V value) {
        return this.get(this.putAsync(key, value));
    }

    @Override
    public RFuture<Boolean> putAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], ARGV[1], ARGV[2]); redis.call('rpush', KEYS[2], ARGV[3]); return 1; ", Arrays.asList(this.getRawName(), setName), keyState, keyHash, valueState);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('lrem', KEYS[2], 1, ARGV[2]); if res == 1 and redis.call('llen', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return res; ", Arrays.asList(this.getRawName(), setName), keyState, valueState);
    }

    @Override
    public RFuture<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local n = 0; for i=3, #ARGV, 5000 do n = n + redis.call('rpush', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; return n; ", Arrays.asList(this.getRawName(), setName), params.toArray());
    }

    @Override
    public RList<V> get(final K key) {
        String keyHash = this.keyHash(key);
        final String setName = this.getValuesName(keyHash);
        return new RedissonList<V>(this.codec, this.commandExecutor, setName, null){

            @Override
            public RFuture<Boolean> addAsync(V value) {
                return RedissonListMultimap.this.putAsync(key, value);
            }

            @Override
            public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
                return RedissonListMultimap.this.putAllAsync(key, c);
            }

            @Override
            public RFuture<Boolean> removeAsync(Object value) {
                return RedissonListMultimap.this.removeAsync(key, value);
            }

            @Override
            public RFuture<Boolean> removeAllAsync(Collection<?> c) {
                if (c.isEmpty()) {
                    return new CompletableFutureWrapper<Boolean>(false);
                }
                ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
                args.add(this.encodeMapKey(key));
                this.encode(args, c);
                return this.commandExecutor.evalWriteAsync(RedissonListMultimap.this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local v = 0 for i = 2, #ARGV, 1 do if redis.call('lrem', KEYS[2], 0, ARGV[i]) == 1 then v = 1; end end if v == 1 and redis.call('exists', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end return v", Arrays.asList(RedissonListMultimap.this.getRawName(), setName), args.toArray());
            }

            @Override
            public RFuture<Boolean> deleteAsync() {
                ByteBuf keyState = this.encodeMapKey(key);
                return RedissonListMultimap.this.fastRemoveAsync(Arrays.asList(keyState), Arrays.asList(RedissonListMultimap.this.getRawName(), setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
            }

            @Override
            public RFuture<Boolean> clearExpireAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Long> remainTimeToLiveAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Void> renameAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> renamenxAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }
        };
    }

    @Override
    public List<V> getAll(K key) {
        return (List)this.get(this.getAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LRANGE, setName, 0, -1);
    }

    @Override
    public List<V> removeAll(Object key) {
        return (List)this.get(this.removeAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getRawName(), setName), keyState);
    }

    @Override
    public List<V> replaceValues(K key, Iterable<? extends V> values) {
        return (List)this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    public RFuture<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('lrange', KEYS[2], 0, -1); redis.call('del', KEYS[2]); if #ARGV > 2 then for i=3, #ARGV, 5000 do redis.call('rpush', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; end; return members; ", Arrays.asList(this.getRawName(), setName), params.toArray());
    }

    @Override
    Iterator<V> valuesIterator() {
        return new RedissonListMultimapIterator<K, V, V>(this, this.commandExecutor, this.codec){

            @Override
            V getValue(V entry) {
                return entry;
            }
        };
    }

    @Override
    RedissonMultiMapIterator<K, V, Map.Entry<K, V>> entryIterator() {
        return new RedissonListMultimapIterator(this, this.commandExecutor, this.codec);
    }

    @Override
    protected <T extends ObjectListener> int addListener(String name, T listener, BiConsumer<T, String> consumer) {
        if (listener instanceof ListAddListener || listener instanceof ListRemoveListener) {
            String prefix = this.getValuesName("");
            return this.addListener(name, listener, consumer, m -> m.startsWith(prefix));
        }
        return super.addListener(name, listener, consumer);
    }

    @Override
    protected <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer) {
        if (listener instanceof ListAddListener || listener instanceof ListRemoveListener) {
            String prefix = this.getValuesName("");
            return this.addListenerAsync(name, listener, consumer, m -> m.startsWith(prefix));
        }
        return super.addListenerAsync(name, listener, consumer);
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof ListAddListener) {
            return this.addListener("__keyevent@*:rpush", (ListAddListener)listener, ListAddListener::onListAdd);
        }
        if (listener instanceof ListRemoveListener) {
            return this.addListener("__keyevent@*:lrem", (ListRemoveListener)listener, ListRemoveListener::onListRemove);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof ListAddListener) {
            return this.addListenerAsync("__keyevent@*:rpush", (ListAddListener)listener, ListAddListener::onListAdd);
        }
        if (listener instanceof ListRemoveListener) {
            return this.addListenerAsync("__keyevent@*:lrem", (ListRemoveListener)listener, ListRemoveListener::onListRemove);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:rpush", "__keyevent@*:lrem");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(listenerId, "__keyevent@*:rpush", "__keyevent@*:lrem");
    }
}

