/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.MetricsClassVisitor;
import com.uwyn.rife.continuations.ResumableClassAdapter;
import com.uwyn.rife.continuations.TypesClassVisitor;
import com.uwyn.rife.continuations.asm.ClassReader;
import com.uwyn.rife.continuations.asm.ClassWriter;
import java.util.logging.Level;

public class ContinuationInstrumentor {
    public static byte[] instrument(byte[] raw_bytes, String classname, boolean skip_debug) throws ClassNotFoundException {
        byte[] resumable_bytes = null;
        try {
            ContinuationDebug.LOGGER.finest("METRICS:");
            ClassReader metrics_reader = new ClassReader(raw_bytes);
            MetricsClassVisitor metrics_visitor = new MetricsClassVisitor(classname, ContinuationConfig.getInstance().getEntryMethod());
            metrics_reader.accept(metrics_visitor, skip_debug);
            ContinuationDebug.LOGGER.finest("\n");
            if (metrics_visitor.getPauseCount() > 0) {
                ContinuationDebug.LOGGER.finest("TYPES:");
                ClassReader types_reader = new ClassReader(raw_bytes);
                TypesClassVisitor types_visitor = new TypesClassVisitor(metrics_visitor, classname, ContinuationConfig.getInstance().getEntryMethod());
                types_reader.accept(types_visitor, skip_debug);
                ContinuationDebug.LOGGER.finest("\n");
                ContinuationDebug.LOGGER.finest("SOURCE:");
                ClassReader resumable_reader = new ClassReader(raw_bytes);
                ClassWriter resumable_writer = new ClassWriter(true);
                ResumableClassAdapter resumable_visitor = new ResumableClassAdapter(metrics_visitor, types_visitor, classname, ContinuationConfig.getInstance().getEntryMethod(), resumable_writer);
                resumable_reader.accept(resumable_visitor, skip_debug);
                resumable_bytes = resumable_writer.toByteArray();
                ContinuationDebug.LOGGER.finest("\n");
                if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                    ContinuationDebug.LOGGER.finest("RESULT:");
                    ClassReader reporting_reader = new ClassReader(resumable_bytes);
                    ResumableClassAdapter reporting_visitor = new ResumableClassAdapter(null, null, classname, ContinuationConfig.getInstance().getEntryMethod(), null);
                    reporting_reader.accept(reporting_visitor, skip_debug);
                }
            }
        }
        catch (Exception e) {
            throw new ClassNotFoundException(classname, e);
        }
        return resumable_bytes;
    }
}

