/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.logging.LoggingPreferences;

public class DesiredCapabilities
implements Serializable,
Capabilities {
    private final Map<String, Object> capabilities = new HashMap<String, Object>();

    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        Object value;
        this.capabilities.putAll(rawMap);
        if (rawMap.containsKey("unexpectedAlertBehaviour")) {
            this.capabilities.put("unhandledPromptBehavior", rawMap.get("unexpectedAlertBehaviour"));
        }
        if (rawMap.containsKey("loggingPrefs") && rawMap.get("loggingPrefs") instanceof Map) {
            LoggingPreferences prefs = new LoggingPreferences();
            Map prefsMap = (Map)rawMap.get("loggingPrefs");
            for (String logType : prefsMap.keySet()) {
                prefs.enable(logType, LogLevelMapping.toLevel((String)prefsMap.get(logType)));
            }
            this.capabilities.put("loggingPrefs", prefs);
        }
        if ((value = this.capabilities.get("platform")) instanceof String) {
            try {
                this.capabilities.put("platform", Platform.fromString((String)((String)value)));
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
    }

    public DesiredCapabilities(Capabilities other) {
        if (other != null) {
            this.merge(other);
        }
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            if (caps == null) continue;
            this.merge(caps);
        }
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public boolean acceptInsecureCerts() {
        if (this.capabilities.containsKey("acceptInsecureCerts")) {
            Object raw = this.capabilities.get("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    public Object getCapability(String capabilityName) {
        return this.capabilities.get(capabilityName);
    }

    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        if (extraCapabilities != null) {
            this.capabilities.putAll(extraCapabilities.asMap());
            if (extraCapabilities.getCapability("unexpectedAlertBehaviour") != null) {
                this.capabilities.put("unhandledPromptBehavior", extraCapabilities.getCapability("unexpectedAlertBehaviour"));
            }
        }
        return this;
    }

    public void setCapability(String capabilityName, boolean value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String capabilityName, String value) {
        if ("platform".equals(capabilityName)) {
            try {
                this.capabilities.put(capabilityName, Platform.fromString((String)value));
            }
            catch (WebDriverException ex) {
                this.capabilities.put(capabilityName, value);
            }
        } else {
            if ("unexpectedAlertBehaviour".equals(capabilityName)) {
                this.capabilities.put("unhandledPromptBehavior", value);
            }
            this.capabilities.put(capabilityName, value);
        }
    }

    public void setCapability(String capabilityName, Platform value) {
        this.capabilities.put(capabilityName, value);
    }

    public void setCapability(String key, Object value) {
        if ("platform".equals(key) && value instanceof String) {
            this.capabilities.put(key, Platform.fromString((String)((String)value)));
        } else {
            this.capabilities.put(key, value);
        }
    }

    public Map<String, ?> asMap() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public static DesiredCapabilities android() {
        return new DesiredCapabilities("android", "", Platform.ANDROID);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities capabilities = new DesiredCapabilities("firefox", "", Platform.ANY);
        capabilities.setCapability("acceptInsecureCerts", true);
        return capabilities;
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities edge() {
        return new DesiredCapabilities("MicrosoftEdge", "", Platform.WINDOWS);
    }

    public static DesiredCapabilities internetExplorer() {
        DesiredCapabilities capabilities = new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
        capabilities.setCapability("ensureCleanSession", true);
        return capabilities;
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iPhone", "", Platform.MAC);
    }

    public static DesiredCapabilities ipad() {
        return new DesiredCapabilities("iPad", "", Platform.MAC);
    }

    @Deprecated
    public static DesiredCapabilities opera() {
        return new DesiredCapabilities("opera", "", Platform.ANY);
    }

    public static DesiredCapabilities operaBlink() {
        return new DesiredCapabilities("operablink", "", Platform.ANY);
    }

    public static DesiredCapabilities safari() {
        return new DesiredCapabilities("safari", "", Platform.MAC);
    }

    public static DesiredCapabilities phantomjs() {
        return new DesiredCapabilities("phantomjs", "", Platform.ANY);
    }

    public String toString() {
        return String.format("Capabilities [%s]", this.shortenMapValues(this.capabilities));
    }

    private Map<String, Object> shortenMapValues(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                newMap.put(entry.getKey(), this.shortenMapValues((Map)entry.getValue()));
                continue;
            }
            String value = String.valueOf(entry.getValue());
            if (value.length() > 1024) {
                value = value.substring(0, 29) + "...";
            }
            newMap.put(entry.getKey(), value);
        }
        return newMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesiredCapabilities)) {
            return false;
        }
        DesiredCapabilities that = (DesiredCapabilities)o;
        return this.capabilities.equals(that.capabilities);
    }

    public int hashCode() {
        return this.capabilities.hashCode();
    }
}

