/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.proxy;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.RemoteException;
import org.openqa.grid.common.exception.RemoteNotReachableException;
import org.openqa.grid.common.exception.RemoteUnregisterException;
import org.openqa.grid.internal.BaseRemoteProxy;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.listeners.TimeoutListener;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.grid.web.servlet.beta.WebProxyHtmlRendererBeta;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedAttribute;
import org.openqa.selenium.remote.server.jmx.ManagedService;

@ManagedService(description="Selenium Grid Hub TestSlot")
public class DefaultRemoteProxy
extends BaseRemoteProxy
implements TimeoutListener,
SelfHealingProxy,
CommandListener,
TestSessionListener {
    private static final Logger LOG = Logger.getLogger(DefaultRemoteProxy.class.getName());
    public static final int DEFAULT_POLLING_INTERVAL = 10000;
    public static final int DEFAULT_UNREGISTER_DELAY = 60000;
    public static final int DEFAULT_DOWN_POLLING_LIMIT = 2;
    private volatile int pollingInterval = 10000;
    private volatile int unregisterDelay = 60000;
    private volatile int downPollingLimit = 2;
    private final HtmlRenderer renderer = new WebProxyHtmlRendererBeta(this);
    private volatile boolean down = false;
    private volatile boolean poll = true;
    private List<RemoteException> errors = new CopyOnWriteArrayList<RemoteException>();
    private Thread pollingThread = null;

    public DefaultRemoteProxy(RegistrationRequest request, GridRegistry registry) {
        super(request, registry);
        this.pollingInterval = this.config.nodePolling != null ? this.config.nodePolling : 10000;
        this.unregisterDelay = this.config.unregisterIfStillDownAfter != null ? this.config.unregisterIfStillDownAfter : 60000;
        this.downPollingLimit = this.config.downPollingLimit != null ? this.config.downPollingLimit : 2;
        new JMXHelper().unregister(this.getObjectName());
        new JMXHelper().register(this);
    }

    @Override
    public void beforeRelease(TestSession session) {
        if (session.getExternalKey() == null) {
            return;
        }
        boolean ok = session.sendDeleteSessionRequest();
        if (!ok) {
            LOG.warning("Error releasing the resources on timeout for session " + session);
        }
    }

    @Override
    public void afterCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", request.getMethod() + " - " + request.getPathInfo() + " executed.");
    }

    @Override
    public void beforeCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", request.getMethod() + " - " + request.getPathInfo() + " executing ...");
    }

    @Override
    public HtmlRenderer getHtmlRender() {
        return this.renderer;
    }

    @ManagedAttribute
    public boolean isAlive() {
        try {
            this.getStatus();
            return true;
        }
        catch (Exception e) {
            LOG.fine("Failed to check status of node: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void startPolling() {
        this.pollingThread = new Thread(new Runnable(){
            int failedPollingTries = 0;
            long downSince = 0L;

            @Override
            public void run() {
                while (DefaultRemoteProxy.this.poll) {
                    try {
                        Thread.sleep(DefaultRemoteProxy.this.pollingInterval);
                        if (!DefaultRemoteProxy.this.isAlive()) {
                            if (!DefaultRemoteProxy.this.down) {
                                ++this.failedPollingTries;
                                if (this.failedPollingTries < DefaultRemoteProxy.this.downPollingLimit) continue;
                                this.downSince = System.currentTimeMillis();
                                DefaultRemoteProxy.this.addNewEvent(new RemoteNotReachableException(String.format("Marking the node %s as down: cannot reach the node for %s tries", DefaultRemoteProxy.this, this.failedPollingTries)));
                                continue;
                            }
                            long downFor = System.currentTimeMillis() - this.downSince;
                            if (downFor <= (long)DefaultRemoteProxy.this.unregisterDelay) continue;
                            DefaultRemoteProxy.this.addNewEvent(new RemoteUnregisterException(String.format("Unregistering the node %s because it's been down for %s milliseconds", DefaultRemoteProxy.this, downFor)));
                            continue;
                        }
                        DefaultRemoteProxy.this.down = false;
                        this.failedPollingTries = 0;
                        this.downSince = 0L;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }, "RemoteProxy failure poller thread for " + this.getId());
        this.pollingThread.start();
    }

    @Override
    public void stopPolling() {
        this.poll = false;
        this.pollingThread.interrupt();
    }

    @Override
    public void addNewEvent(RemoteException event) {
        this.errors.add(event);
        this.onEvent(this.errors, event);
    }

    @Override
    public void onEvent(List<RemoteException> events, RemoteException lastInserted) {
        for (RemoteException e : events) {
            if (e instanceof RemoteNotReachableException) {
                LOG.info(e.getMessage());
                this.down = true;
                this.errors.clear();
            }
            if (!(e instanceof RemoteUnregisterException)) continue;
            LOG.info(e.getMessage());
            Object registry = this.getRegistry();
            registry.removeIfPresent(this);
        }
    }

    @Override
    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        if (this.down) {
            return null;
        }
        return super.getNewSession(requestedCapability);
    }

    @ManagedAttribute
    public boolean isDown() {
        return this.down;
    }

    @Override
    public void beforeSession(TestSession session) {
    }

    @Override
    public void afterSession(TestSession session) {
    }

    @Override
    public void teardown() {
        super.teardown();
        this.stopPolling();
    }

    public ObjectName getObjectName() {
        try {
            return new ObjectName(String.format("org.seleniumhq.grid:type=RemoteProxy,node=\"%s\"", this.getRemoteHost()));
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            return null;
        }
    }
}

