/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.clisupport.model;

import java.util.Arrays;
import java.util.List;
import org.simplejavamail.internal.util.ListUtil;
import org.simplejavamail.internal.util.StringUtil;

public class CliDeclaredOptionValue {
    private final String name;
    private final String helpLabel;
    private final String description;
    private final boolean required;
    private final String[] examples;

    public CliDeclaredOptionValue(String name, String helpLabel, String description, boolean required, String[] examples) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.<init> must not be null");
        }
        if (helpLabel == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.<init> must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.<init> must not be null");
        }
        if (examples == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 4 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.<init> must not be null");
        }
        this.name = name;
        this.helpLabel = helpLabel;
        this.description = description;
        this.required = required;
        this.examples = (String[])examples.clone();
    }

    public String formatDescription() {
        if (this.examples.length == 0) {
            String string = this.description;
            if (string == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.formatDescription must not return null");
            }
            return string;
        }
        if (this.examples.length == 1) {
            String string = this.description + "\n    example: " + this.examples[0];
            if (string == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.formatDescription must not return null");
            }
            return string;
        }
        String string = this.description + "\n    examples: " + CliDeclaredOptionValue.formatExamplesText("    examples: ".length(), Arrays.asList(this.examples));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.formatDescription must not return null");
        }
        return string;
    }

    private static String formatExamplesText(int indent, List<String> examples) {
        if (examples == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.formatExamplesText must not be null");
        }
        StringBuilder examplesFormatted = new StringBuilder().append(ListUtil.getFirst(examples)).append("\n");
        for (String example : examples.subList(1, examples.size())) {
            examplesFormatted.append(StringUtil.nStrings(indent, " ")).append(example).append("\n");
        }
        String string = examplesFormatted.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.formatExamplesText must not return null");
        }
        return string;
    }

    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.getName must not return null");
        }
        return string;
    }

    public String getHelpLabel() {
        String string = this.helpLabel;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionValue.getHelpLabel must not return null");
        }
        return string;
    }

    public boolean isRequired() {
        return this.required;
    }
}

