/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public final class Pkcs12Config {
    private static final long serialVersionUID = 1234567L;
    @NotNull
    private final InputStream pkcs12StoreStream;
    @NotNull
    private final char[] storePassword;
    @NotNull
    private final String keyAlias;
    @NotNull
    private final char[] keyPassword;

    private Pkcs12Config(@NotNull InputStream pkcs12StoreStream, @NotNull char[] storePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        if (pkcs12StoreStream == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config.<init> must not be null");
        }
        if (storePassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/mailer/config/Pkcs12Config.<init> must not be null");
        }
        if (keyAlias == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/api/mailer/config/Pkcs12Config.<init> must not be null");
        }
        if (keyPassword == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/api/mailer/config/Pkcs12Config.<init> must not be null");
        }
        this.pkcs12StoreStream = pkcs12StoreStream;
        this.storePassword = storePassword;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    public static Pkcs12ConfigBuilder builder() {
        Pkcs12ConfigBuilder pkcs12ConfigBuilder = new Pkcs12ConfigBuilder();
        if (pkcs12ConfigBuilder == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.builder must not return null");
        }
        return pkcs12ConfigBuilder;
    }

    @NotNull
    public InputStream getPkcs12StoreStream() {
        InputStream inputStream = this.pkcs12StoreStream;
        if (inputStream == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.getPkcs12StoreStream must not return null");
        }
        return inputStream;
    }

    @NotNull
    public char[] getStorePassword() {
        char[] cArray = (char[])this.storePassword.clone();
        if (cArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.getStorePassword must not return null");
        }
        return cArray;
    }

    @NotNull
    public String getKeyAlias() {
        String string = this.keyAlias;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.getKeyAlias must not return null");
        }
        return string;
    }

    @NotNull
    public char[] getKeyPassword() {
        char[] cArray = (char[])this.keyPassword.clone();
        if (cArray == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.getKeyPassword must not return null");
        }
        return cArray;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pkcs12Config{");
        sb.append("pkcs12StoreStream=").append(this.pkcs12StoreStream);
        sb.append(", storePassword=***");
        sb.append(", keyAlias='").append(this.keyAlias).append('\'');
        sb.append(", keyPassword=***");
        sb.append('}');
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config.toString must not return null");
        }
        return string;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pkcs12Config that = (Pkcs12Config)o;
        return MiscUtil.inputStreamEqual(this.pkcs12StoreStream, that.pkcs12StoreStream) && Arrays.equals(this.storePassword, that.storePassword) && this.keyAlias.equals(that.keyAlias) && Arrays.equals(this.keyPassword, that.keyPassword);
    }

    public int hashCode() {
        int result = Objects.hash(this.pkcs12StoreStream, this.keyAlias);
        result = 31 * result + Arrays.hashCode(this.storePassword);
        result = 31 * result + Arrays.hashCode(this.keyPassword);
        return result;
    }

    public static class Pkcs12ConfigBuilder {
        private InputStream pkcs12StoreStream;
        private char[] storePassword;
        private String keyAlias;
        private char[] keyPassword;

        private Pkcs12ConfigBuilder() {
        }

        public Pkcs12ConfigBuilder pkcs12Store(String pkcs12StorePath) {
            if (pkcs12StorePath == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not be null");
            }
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this.pkcs12Store(new File(pkcs12StorePath));
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream is meant to travel outside method")
        public Pkcs12ConfigBuilder pkcs12Store(File pkcs12StorePath) {
            Pkcs12ConfigBuilder pkcs12ConfigBuilder;
            if (pkcs12StorePath == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not be null");
            }
            try {
                pkcs12ConfigBuilder = this.pkcs12Store(new FileInputStream(pkcs12StorePath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(String.format("error reading PKCS12 store from File [%s]", pkcs12StorePath), e);
            }
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder pkcs12Store(InputStream pkcs12StoreStream) {
            if (pkcs12StoreStream == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not be null");
            }
            this.pkcs12StoreStream = pkcs12StoreStream;
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.pkcs12Store must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder storePassword(char[] storePassword) {
            if (storePassword == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.storePassword must not be null");
            }
            this.storePassword = (char[])storePassword.clone();
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.storePassword must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder storePassword(String storePassword) {
            if (storePassword == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.storePassword must not be null");
            }
            this.storePassword = storePassword.toCharArray();
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.storePassword must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder keyAlias(String keyAlias) {
            if (keyAlias == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyAlias must not be null");
            }
            this.keyAlias = keyAlias;
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyAlias must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder keyPassword(char[] keyPassword) {
            if (keyPassword == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyPassword must not be null");
            }
            this.keyPassword = (char[])keyPassword.clone();
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyPassword must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12ConfigBuilder keyPassword(String keyPassword) {
            if (keyPassword == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyPassword must not be null");
            }
            this.keyPassword = keyPassword.toCharArray();
            Pkcs12ConfigBuilder pkcs12ConfigBuilder = this;
            if (pkcs12ConfigBuilder == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.keyPassword must not return null");
            }
            return pkcs12ConfigBuilder;
        }

        public Pkcs12Config build() {
            Pkcs12Config pkcs12Config = new Pkcs12Config(this.pkcs12StoreStream, this.storePassword, this.keyAlias, this.keyPassword);
            if (pkcs12Config == null) {
                throw new IllegalStateException("NotNull method org/simplejavamail/api/mailer/config/Pkcs12Config$Pkcs12ConfigBuilder.build must not return null");
            }
            return pkcs12Config;
        }
    }
}

