/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ListUtil {
    private ListUtil() {
    }

    public static <T> T getFirstOrNull(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getFirstOrNull must not be null");
        }
        T t = ListUtil.getFirst(list, null);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getFirstOrNull must not return null");
        }
        return t;
    }

    public static <T> T getLastOrNull(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getLastOrNull must not be null");
        }
        T t = ListUtil.getLast(list, null);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getLastOrNull must not return null");
        }
        return t;
    }

    public static <T> T getFirst(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getFirst must not be null");
        }
        T t = list.get(0);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getFirst must not return null");
        }
        return t;
    }

    public static <T> T getLast(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getLast must not be null");
        }
        T t = list.get(list.size() - 1);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getLast must not return null");
        }
        return t;
    }

    public static <T> T getFirst(List<T> list, T t) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getFirst must not be null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/ListUtil.getFirst must not be null");
        }
        T t2 = ListUtil.isEmpty(list) ? t : list.get(0);
        if (t2 == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getFirst must not return null");
        }
        return t2;
    }

    public static <T> T getLast(List<T> list, T t) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.getLast must not be null");
        }
        if (t == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/ListUtil.getLast must not be null");
        }
        T t2 = ListUtil.isEmpty(list) ? t : list.get(list.size() - 1);
        if (t2 == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.getLast must not return null");
        }
        return t2;
    }

    public static <T> boolean isEmpty(List<T> list) {
        if (list == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.isEmpty must not be null");
        }
        return list == null || list.isEmpty();
    }

    public static <T> ArrayList<T> merge(List<T> list1, List<T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.merge must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/ListUtil.merge must not be null");
        }
        ArrayList<T> merged = new ArrayList<T>(list1);
        merged.addAll(list2);
        ArrayList<T> arrayList = merged;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.merge must not return null");
        }
        return arrayList;
    }

    public static <K, V> HashMap<K, V> merge(Map<K, V> map1, Map<K, V> map2) {
        if (map1 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/internal/util/ListUtil.merge must not be null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/ListUtil.merge must not be null");
        }
        HashMap<K, V> merged = new HashMap<K, V>();
        merged.putAll(map1);
        merged.putAll(map2);
        HashMap<K, V> hashMap = merged;
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/ListUtil.merge must not return null");
        }
        return hashMap;
    }
}

