/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public final class Preconditions {
    private Preconditions() {
    }

    @NotNull
    public static <T> T checkNonEmptyArgument(@Nullable T arg, @NotNull String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/Preconditions.checkNonEmptyArgument must not be null");
        }
        T t = Preconditions.verifyNonnull(arg, String.format("%s is required", parameterName));
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/Preconditions.checkNonEmptyArgument must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T assumeNonNull(@Nullable T arg) {
        T t = Preconditions.verifyNonnull(arg, "argument was assumed nonNull, but was null");
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/Preconditions.assumeNonNull must not return null");
        }
        return t;
    }

    @NotNull
    private static <T> T verifyNonnull(@Nullable T arg, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/Preconditions.verifyNonnull must not be null");
        }
        if (MiscUtil.valueNullOrEmpty(arg)) {
            throw new IllegalArgumentException(message);
        }
        T t = arg;
        if (t == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/internal/util/Preconditions.verifyNonnull must not return null");
        }
        return t;
    }

    public static boolean assumeTrue(boolean state, @NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/internal/util/Preconditions.assumeTrue must not be null");
        }
        if (!state) {
            throw new IllegalArgumentException(msg);
        }
        return true;
    }
}

