/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import org.specs.Example;
import org.specs.ExtendedThrowable$;
import org.specs.Specification;
import org.specs.Sut;
import org.specs.runner.OutputReporter;
import org.specs.runner.OutputReporter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public abstract class OutputReporter$class {
    public static void $init$(OutputReporter $this) {
    }

    public static final String parens$1(OutputReporter $this, Throwable f) {
        return " (" + ExtendedThrowable$.MODULE$.toExtendedThrowable(f).location() + ")";
    }

    private static final String status$1(OutputReporter $this, Example example) {
        return example.errors().size() + example.failures().size() > 0 ? "x " : (example.skipped().size() > 0 ? "o " : "+ ");
    }

    private static final String plural$1(OutputReporter $this, int nb) {
        return nb > 1 ? "s" : "";
    }

    public static void reportExample(OutputReporter $this, Example example, String padding$5) {
        $this.println(padding$5 + OutputReporter$class.status$1($this, example) + example.description());
        List list = example.skipped().toList();
        List list2 = example.failures().toList();
        example.errors().toList().$colon$colon$colon(list2).$colon$colon$colon(list).foreach((Function1)new OutputReporter$.anonfun.reportExample.1($this, padding$5));
    }

    public static void reportExamples(OutputReporter $this, Iterable examples, String padding$4) {
        examples.foreach((Function1)new OutputReporter$.anonfun.reportExamples.1($this, padding$4));
    }

    public static void printStats(OutputReporter $this, Tuple5 stat, String padding) {
        Tuple5 tuple5 = stat;
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Tuple5 tuple52 = new Tuple5(tuple5._1(), tuple5._2(), tuple5._3(), tuple5._4(), tuple5._5());
        int examplesNb = BoxesRunTime.unboxToInt((Object)tuple52._1());
        int assertionsNb2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
        int failuresNb = BoxesRunTime.unboxToInt((Object)tuple52._3());
        int errorsNb = BoxesRunTime.unboxToInt((Object)tuple52._4());
        int skippedNb = BoxesRunTime.unboxToInt((Object)tuple52._5());
        $this.println(padding + "Finished in " + $this.timer().stop());
        $this.println(padding + BoxesRunTime.boxToInteger((int)examplesNb) + " example" + OutputReporter$class.plural$1($this, examplesNb) + (skippedNb > 0 ? " (" + BoxesRunTime.boxToInteger((int)skippedNb) + " skipped)" : "") + ", " + BoxesRunTime.boxToInteger((int)assertionsNb2) + " assertion" + OutputReporter$class.plural$1($this, assertionsNb2) + ", " + BoxesRunTime.boxToInteger((int)failuresNb) + " failure" + OutputReporter$class.plural$1($this, failuresNb) + ", " + BoxesRunTime.boxToInteger((int)errorsNb) + " error" + OutputReporter$class.plural$1($this, errorsNb));
        $this.println("");
    }

    public static void printStats(OutputReporter $this, Sut sut, String padding) {
        $this.println(padding + "Total for SUT \"" + sut.description() + "\":");
        $this.printStats($this.stats(sut), padding);
    }

    public static void printSut(OutputReporter $this, Sut sut, String padding$3) {
        $this.println(padding$3 + sut.description() + " " + sut.verb() + sut.skippedSut().map((Function1)new OutputReporter$.anonfun.printSut.1($this)).getOrElse((Function0)new OutputReporter$.anonfun.printSut.2($this)));
        sut.literalDescription().foreach((Function1)new OutputReporter$.anonfun.printSut.3($this, padding$3));
        $this.reportExamples((Iterable)sut.examples(), padding$3);
        $this.println("");
    }

    public static void reportSut(OutputReporter $this, Sut sut, String padding) {
        $this.printSut(sut, padding);
        $this.printStats(sut, padding);
    }

    public static void reportSuts(OutputReporter $this, Iterable suts, String padding$2) {
        if (suts.toList().size() > 1) {
            suts.foreach((Function1)new OutputReporter$.anonfun.reportSuts.1($this, padding$2));
        } else {
            suts.foreach((Function1)new OutputReporter$.anonfun.reportSuts.2($this, padding$2));
        }
    }

    public static Tuple5 stats(OutputReporter $this, Example example) {
        return $this.toAddableTuple(new Tuple5((Object)(example.subExamples().isEmpty() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)example.assertionsNb()), (Object)BoxesRunTime.boxToInteger((int)example.failures().size()), (Object)BoxesRunTime.boxToInteger((int)example.errors().size()), (Object)BoxesRunTime.boxToInteger((int)example.skipped().size()))).$plus((Tuple5)example.subExamples().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.4($this)));
    }

    public static Tuple5 stats(OutputReporter $this, Sut sut) {
        return (Tuple5)sut.examples().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.3($this));
    }

    public static Tuple5 stats(OutputReporter $this, Specification spec) {
        return $this.toAddableTuple((Tuple5)spec.suts().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.1($this))).$plus((Tuple5)spec.subSpecifications().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new OutputReporter$.anonfun.stats.2($this)));
    }

    public static OutputReporter.AddableTuple toAddableTuple(OutputReporter $this, Tuple5 t1) {
        return new OutputReporter.AddableTuple($this, t1);
    }

    public static void reportSpec(OutputReporter $this, Specification spec, String padding) {
        $this.println(padding + "Specification \"" + spec.name() + "\"");
        $this.report((Iterable)spec.subSpecifications(), padding + "  ");
        $this.reportSuts((Iterable)spec.suts(), padding + "  ");
        $this.println(padding + "Total for specification \"" + spec.name() + "\":");
        $this.printStats($this.stats(spec), padding);
    }

    public static void reportSpec(OutputReporter $this, Specification spec) {
        $this.reportSpec(spec, "");
    }

    public static void report(OutputReporter $this, Iterable specs, String padding$1) {
        specs.foreach((Function1)new OutputReporter$.anonfun.report.2($this, padding$1));
    }

    public static void report(OutputReporter $this, Iterable specs) {
        specs.foreach((Function1)new OutputReporter$.anonfun.report.1($this));
    }
}

