/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.mp.base;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseService;
import org.springblade.core.secure.BladeUser;
import org.springblade.core.secure.utils.SecureUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springframework.validation.annotation.Validated;

@Validated
public class BaseServiceImpl<M extends BaseMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements BaseService<T> {
    public boolean save(T entity) {
        BladeUser user = SecureUtil.getUser();
        if (user != null) {
            ((BaseEntity)entity).setCreateUser(user.getUserId());
            ((BaseEntity)entity).setUpdateUser(user.getUserId());
        }
        Date now = DateUtil.now();
        ((BaseEntity)entity).setCreateTime(now);
        ((BaseEntity)entity).setUpdateTime(now);
        if (((BaseEntity)entity).getStatus() == null) {
            ((BaseEntity)entity).setStatus(1);
        }
        ((BaseEntity)entity).setIsDeleted(0);
        return super.save(entity);
    }

    public boolean updateById(T entity) {
        BladeUser user = SecureUtil.getUser();
        if (user != null) {
            ((BaseEntity)entity).setUpdateUser(user.getUserId());
        }
        ((BaseEntity)entity).setUpdateTime(DateUtil.now());
        return super.updateById(entity);
    }

    @Override
    public boolean deleteLogic(@NotEmpty List<Integer> ids) {
        return super.removeByIds(ids);
    }
}

