/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.amqp.support.postprocessor.AbstractDecompressingPostProcessor;
import org.springframework.util.Assert;

public class UnzipPostProcessor
extends AbstractDecompressingPostProcessor {
    public UnzipPostProcessor() {
    }

    public UnzipPostProcessor(boolean alwaysDecompress) {
        super(alwaysDecompress);
    }

    @Override
    protected InputStream getDecompressorStream(InputStream zipped) throws IOException {
        ZipInputStream zipper = new ZipInputStream(zipped);
        ZipEntry entry = zipper.getNextEntry();
        String entryName = entry.getName();
        Assert.state((boolean)"amqp".equals(entryName), () -> "Zip 'entryName' must be 'amqp', not '" + entryName + "'");
        return zipper;
    }

    @Override
    protected String getEncoding() {
        return "zip";
    }
}

