/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.util.Assert;

public class DefaultExecutionContextSerializer
implements ExecutionContextSerializer {
    private Serializer serializer = new DefaultSerializer();
    private Deserializer deserializer = new DefaultDeserializer();

    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, (String)"context is required");
        Assert.notNull((Object)out, (String)"OutputStream is required");
        for (Object value : context.values()) {
            Assert.notNull((Object)value, (String)"A null value was found");
            if (value instanceof Serializable) continue;
            throw new IllegalArgumentException("Value: [" + value + "] must be serializable. Object of class: [" + value.getClass().getName() + "] must be an instance of " + Serializable.class);
        }
        this.serializer.serialize(context, out);
    }

    public Map<String, Object> deserialize(InputStream inputStream) throws IOException {
        return (Map)this.deserializer.deserialize(inputStream);
    }
}

