/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.transaction.TransactionAwareProxyFactory;
import org.springframework.util.Assert;
import org.springframework.util.SerializationUtils;

@Deprecated
public class MapExecutionContextDao
implements ExecutionContextDao {
    private final ConcurrentMap<ContextKey, ExecutionContext> contexts = TransactionAwareProxyFactory.createAppendOnlyTransactionalMap();

    public void clear() {
        this.contexts.clear();
    }

    private static ExecutionContext copy(ExecutionContext original) {
        return (ExecutionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
    }

    @Override
    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        return MapExecutionContextDao.copy((ExecutionContext)this.contexts.get(ContextKey.step(stepExecution.getId())));
    }

    @Override
    public void updateExecutionContext(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (executionContext != null) {
            this.contexts.put(ContextKey.step(stepExecution.getId()), MapExecutionContextDao.copy(executionContext));
        }
    }

    @Override
    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        return MapExecutionContextDao.copy((ExecutionContext)this.contexts.get(ContextKey.job(jobExecution.getId())));
    }

    @Override
    public void updateExecutionContext(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        if (executionContext != null) {
            this.contexts.put(ContextKey.job(jobExecution.getId()), MapExecutionContextDao.copy(executionContext));
        }
    }

    @Override
    public void saveExecutionContext(JobExecution jobExecution) {
        this.updateExecutionContext(jobExecution);
    }

    @Override
    public void saveExecutionContext(StepExecution stepExecution) {
        this.updateExecutionContext(stepExecution);
    }

    @Override
    public void saveExecutionContexts(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save a null collection of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.saveExecutionContext(stepExecution);
            this.saveExecutionContext(stepExecution.getJobExecution());
        }
    }

    private static final class ContextKey
    implements Comparable<ContextKey>,
    Serializable {
        private final Type type;
        private final long id;

        private ContextKey(Type type, long id) {
            if (type == null) {
                throw new IllegalStateException("Need a non-null type for a context");
            }
            this.type = type;
            this.id = id;
        }

        @Override
        public int compareTo(ContextKey them) {
            if (them == null) {
                return 1;
            }
            int idCompare = new Long(this.id).compareTo(new Long(them.id));
            if (idCompare != 0) {
                return idCompare;
            }
            int typeCompare = this.type.compareTo(them.type);
            if (typeCompare != 0) {
                return typeCompare;
            }
            return 0;
        }

        public boolean equals(Object them) {
            if (them == null) {
                return false;
            }
            if (them instanceof ContextKey) {
                return this.equals((ContextKey)them);
            }
            return false;
        }

        public boolean equals(ContextKey them) {
            if (them == null) {
                return false;
            }
            return this.id == them.id && this.type.equals((Object)them.type);
        }

        public int hashCode() {
            int value = (int)(this.id ^ this.id >>> 32);
            switch (this.type) {
                case STEP: {
                    return value;
                }
                case JOB: {
                    return ~value;
                }
            }
            throw new IllegalStateException("Unknown type encountered in switch: " + (Object)((Object)this.type));
        }

        public static ContextKey step(long id) {
            return new ContextKey(Type.STEP, id);
        }

        public static ContextKey job(long id) {
            return new ContextKey(Type.JOB, id);
        }

        private static enum Type {
            STEP,
            JOB;

        }
    }
}

