/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.core.ResolvableType;

public abstract class CompositeHealthIndicatorConfiguration<H extends HealthIndicator, S> {
    @Autowired
    private HealthAggregator healthAggregator;

    protected HealthIndicator createHealthIndicator(Map<String, S> beans) {
        if (beans.size() == 1) {
            return this.createHealthIndicator(beans.values().iterator().next());
        }
        CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
        for (Map.Entry<String, S> entry : beans.entrySet()) {
            composite.addHealthIndicator(entry.getKey(), this.createHealthIndicator(entry.getValue()));
        }
        return composite;
    }

    protected H createHealthIndicator(S source) {
        Class[] generics = ResolvableType.forClass(CompositeHealthIndicatorConfiguration.class, this.getClass()).resolveGenerics();
        Class indicatorClass = generics[0];
        Class sourceClass = generics[1];
        try {
            return (H)((HealthIndicator)indicatorClass.getConstructor(sourceClass).newInstance(source));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create indicator " + indicatorClass + " for source " + sourceClass, ex);
        }
    }
}

