/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyWriteResponseFilter
implements GlobalFilter,
Ordered {
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;
    private static final Log log = LogFactory.getLog(NettyWriteResponseFilter.class);
    private final List<MediaType> streamingMediaTypes;

    public NettyWriteResponseFilter(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).then(Mono.defer(() -> {
            Connection connection = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
            if (connection == null) {
                return Mono.empty();
            }
            log.trace((Object)"NettyWriteResponseFilter start");
            ServerHttpResponse response = exchange.getResponse();
            NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
            Flux body = connection.inbound().receive().retain().map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
            MediaType contentType = null;
            try {
                contentType = response.getHeaders().getContentType();
            }
            catch (Exception e) {
                log.trace((Object)"invalid media type", (Throwable)e);
            }
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType == null) return false;
        if (!this.streamingMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) return false;
        return true;
    }
}

