/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ServerWebExchangeUtils {
    public static final String PRESERVE_HOST_HEADER_ATTRIBUTE = ServerWebExchangeUtils.qualify("preserveHostHeader");
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = ServerWebExchangeUtils.qualify("uriTemplateVariables");
    public static final String CLIENT_RESPONSE_ATTR = ServerWebExchangeUtils.qualify("gatewayClientResponse");
    public static final String CLIENT_RESPONSE_CONN_ATTR = ServerWebExchangeUtils.qualify("gatewayClientResponseConnection");
    public static final String CLIENT_RESPONSE_HEADER_NAMES = ServerWebExchangeUtils.qualify("gatewayClientResponseHeaderNames");
    public static final String GATEWAY_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayRoute");
    public static final String GATEWAY_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayRequestUrl");
    public static final String GATEWAY_ORIGINAL_REQUEST_URL_ATTR = ServerWebExchangeUtils.qualify("gatewayOriginalRequestUrl");
    public static final String GATEWAY_HANDLER_MAPPER_ATTR = ServerWebExchangeUtils.qualify("gatewayHandlerMapper");
    public static final String GATEWAY_SCHEME_PREFIX_ATTR = ServerWebExchangeUtils.qualify("gatewaySchemePrefix");
    public static final String GATEWAY_PREDICATE_ROUTE_ATTR = ServerWebExchangeUtils.qualify("gatewayPredicateRouteAttr");
    public static final String WEIGHT_ATTR = ServerWebExchangeUtils.qualify("routeWeight");
    public static final String ORIGINAL_RESPONSE_CONTENT_TYPE_ATTR = "original_response_content_type";
    public static final String HYSTRIX_EXECUTION_EXCEPTION_ATTR = ServerWebExchangeUtils.qualify("hystrixExecutionException");
    public static final String GATEWAY_ALREADY_ROUTED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyRouted");
    public static final String GATEWAY_ALREADY_PREFIXED_ATTR = ServerWebExchangeUtils.qualify("gatewayAlreadyPrefixed");
    private static final Log logger = LogFactory.getLog(ServerWebExchangeUtils.class);

    private ServerWebExchangeUtils() {
        throw new AssertionError((Object)"Must not instantiate utility class.");
    }

    private static String qualify(String attr) {
        return ServerWebExchangeUtils.class.getName() + "." + attr;
    }

    public static void setAlreadyRouted(ServerWebExchange exchange) {
        exchange.getAttributes().put(GATEWAY_ALREADY_ROUTED_ATTR, true);
    }

    public static boolean isAlreadyRouted(ServerWebExchange exchange) {
        return (Boolean)exchange.getAttributeOrDefault(GATEWAY_ALREADY_ROUTED_ATTR, (Object)false);
    }

    public static boolean setResponseStatus(ServerWebExchange exchange, HttpStatus httpStatus) {
        boolean response = exchange.getResponse().setStatusCode(httpStatus);
        if (!response && logger.isWarnEnabled()) {
            logger.warn((Object)("Unable to set status code to " + httpStatus + ". Response already committed."));
        }
        return response;
    }

    public static boolean setResponseStatus(ServerWebExchange exchange, HttpStatusHolder statusHolder) {
        if (exchange.getResponse().isCommitted()) {
            return false;
        }
        if (statusHolder.getHttpStatus() != null) {
            return ServerWebExchangeUtils.setResponseStatus(exchange, statusHolder.getHttpStatus());
        }
        if (statusHolder.getStatus() != null && exchange.getResponse() instanceof AbstractServerHttpResponse) {
            ((AbstractServerHttpResponse)exchange.getResponse()).setStatusCodeValue(statusHolder.getStatus());
            return true;
        }
        return false;
    }

    public static boolean containsEncodedParts(URI uri) {
        boolean encoded;
        boolean bl = encoded = uri.getRawQuery() != null && uri.getRawQuery().contains("%") || uri.getRawPath() != null && uri.getRawPath().contains("%");
        if (encoded) {
            try {
                UriComponentsBuilder.fromUri((URI)uri).build(true);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        return encoded;
    }

    public static HttpStatus parse(String statusString) {
        HttpStatus httpStatus;
        try {
            int status = Integer.parseInt(statusString);
            httpStatus = HttpStatus.resolve((int)status);
        }
        catch (NumberFormatException e) {
            httpStatus = HttpStatus.valueOf((String)statusString.toUpperCase());
        }
        return httpStatus;
    }

    public static void addOriginalRequestUrl(ServerWebExchange exchange, URI url) {
        exchange.getAttributes().computeIfAbsent(GATEWAY_ORIGINAL_REQUEST_URL_ATTR, s -> new LinkedHashSet());
        LinkedHashSet uris = (LinkedHashSet)exchange.getRequiredAttribute(GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
        uris.add(url);
    }

    public static AsyncPredicate<ServerWebExchange> toAsyncPredicate(Predicate<? super ServerWebExchange> predicate) {
        Assert.notNull(predicate, (String)"predicate must not be null");
        return t -> Mono.just((Object)predicate.test((ServerWebExchange)t));
    }

    public static void putUriTemplateVariables(ServerWebExchange exchange, Map<String, String> uriVariables) {
        if (exchange.getAttributes().containsKey(URI_TEMPLATE_VARIABLES_ATTRIBUTE)) {
            Map existingVariables = (Map)exchange.getAttributes().get(URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            HashMap<String, String> newVariables = new HashMap<String, String>();
            newVariables.putAll(existingVariables);
            newVariables.putAll(uriVariables);
            exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, newVariables);
        } else {
            exchange.getAttributes().put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
        }
    }

    public static Map<String, String> getUriTemplateVariables(ServerWebExchange exchange) {
        return (Map)exchange.getAttributeOrDefault(URI_TEMPLATE_VARIABLES_ATTRIBUTE, new HashMap());
    }
}

