/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.actuate.GatewayControllerEndpoint;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.NotFoundException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.Ordered;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AbstractGatewayControllerEndpoint
implements ApplicationEventPublisherAware {
    private static final Log log = LogFactory.getLog(GatewayControllerEndpoint.class);
    protected RouteDefinitionLocator routeDefinitionLocator;
    protected List<GlobalFilter> globalFilters;
    protected List<GatewayFilterFactory> GatewayFilters;
    protected RouteDefinitionWriter routeDefinitionWriter;
    protected RouteLocator routeLocator;
    protected ApplicationEventPublisher publisher;

    public AbstractGatewayControllerEndpoint(RouteDefinitionLocator routeDefinitionLocator, List<GlobalFilter> globalFilters, List<GatewayFilterFactory> GatewayFilters, RouteDefinitionWriter routeDefinitionWriter, RouteLocator routeLocator) {
        this.routeDefinitionLocator = routeDefinitionLocator;
        this.globalFilters = globalFilters;
        this.GatewayFilters = GatewayFilters;
        this.routeDefinitionWriter = routeDefinitionWriter;
        this.routeLocator = routeLocator;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @PostMapping(value={"/refresh"})
    public Mono<Void> refresh() {
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent(this));
        return Mono.empty();
    }

    @GetMapping(value={"/globalfilters"})
    public Mono<HashMap<String, Object>> globalfilters() {
        return this.getNamesToOrders(this.globalFilters);
    }

    @GetMapping(value={"/routefilters"})
    public Mono<HashMap<String, Object>> routefilers() {
        return this.getNamesToOrders(this.GatewayFilters);
    }

    private <T> Mono<HashMap<String, Object>> getNamesToOrders(List<T> list) {
        return Flux.fromIterable(list).reduce(new HashMap(), this::putItem);
    }

    private HashMap<String, Object> putItem(HashMap<String, Object> map, Object o) {
        Integer order = null;
        if (o instanceof Ordered) {
            order = ((Ordered)o).getOrder();
        }
        map.put(o.toString(), order);
        return map;
    }

    @PostMapping(value={"/routes/{id}"})
    public Mono<ResponseEntity<Void>> save(@PathVariable String id, @RequestBody Mono<RouteDefinition> route) {
        return this.routeDefinitionWriter.save((Mono<RouteDefinition>)route.map(r -> {
            r.setId(id);
            log.debug((Object)("Saving route: " + route));
            return r;
        })).then(Mono.defer(() -> Mono.just((Object)ResponseEntity.created((URI)URI.create("/routes/" + id)).build())));
    }

    @DeleteMapping(value={"/routes/{id}"})
    public Mono<ResponseEntity<Object>> delete(@PathVariable String id) {
        return this.routeDefinitionWriter.delete((Mono<String>)Mono.just((Object)id)).then(Mono.defer(() -> Mono.just((Object)ResponseEntity.ok().build()))).onErrorResume(t -> t instanceof NotFoundException, t -> Mono.just((Object)ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/routes/{id}/combinedfilters"})
    public Mono<HashMap<String, Object>> combinedfilters(@PathVariable String id) {
        return this.routeLocator.getRoutes().filter(route -> route.getId().equals(id)).reduce(new HashMap(), this::putItem);
    }
}

