/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.Observation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayContext;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public class ObservedResponseHttpHeadersFilter
implements HttpHeadersFilter {
    private static final Log log = LogFactory.getLog(ObservedResponseHttpHeadersFilter.class);
    static final String OBSERVATION_STOPPED = "gateway.observation.stopped";

    @Override
    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        Observation childObservation = (Observation)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR);
        if (childObservation == null) {
            return input;
        }
        GatewayContext context = (GatewayContext)childObservation.getContext();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will instrument the response");
        }
        context.setResponse(exchange.getResponse());
        if (log.isDebugEnabled()) {
            log.debug((Object)("The response was handled for observation " + childObservation));
        }
        childObservation.stop();
        exchange.getAttributes().put(OBSERVATION_STOPPED, "true");
        return input;
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

