/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.config;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClientConfiguration;
import org.springframework.context.annotation.Configuration;

@ConditionalOnBean(value={EurekaDiscoveryClientConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.config.discovery.enabled"}, matchIfMissing=false)
@Configuration
public class DiscoveryClientConfigServiceAutoConfiguration {
    @Autowired
    private EurekaClientConfig clientConfig;
    @Autowired
    private EurekaInstanceConfig instanceConfig;
    @Autowired
    private ConfigurationPropertiesBindingPostProcessor binder;
    @Autowired
    private EurekaDiscoveryClientConfiguration lifecycle;

    @PostConstruct
    public void init() {
        this.lifecycle.stop();
        this.rebind(this.clientConfig, "eurekaClientConfig");
        this.rebind(this.instanceConfig, "eurekaInstanceConfig");
        if (DiscoveryManager.getInstance().getDiscoveryClient() != null) {
            DiscoveryManager.getInstance().getDiscoveryClient().shutdown();
        }
        ApplicationInfoManager.getInstance().initComponent(this.instanceConfig);
        DiscoveryManager.getInstance().initComponent(this.instanceConfig, this.clientConfig);
        this.lifecycle.start();
    }

    private void rebind(Object bean, String name) {
        this.binder.postProcessBeforeInitialization(bean, name);
    }
}

