/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import feign.ribbon.LBClient;
import feign.ribbon.LBClientFactory;
import java.util.Map;
import org.springframework.util.ConcurrentReferenceHashMap;

public class CachingLBClientFactory
implements LBClientFactory {
    private volatile Map<String, LBClient> cache = new ConcurrentReferenceHashMap();
    private final LBClientFactory delegate;

    public CachingLBClientFactory(LBClientFactory delegate) {
        this.delegate = delegate;
    }

    public LBClient create(String clientName) {
        if (this.cache.containsKey(clientName)) {
            return this.cache.get(clientName);
        }
        LBClient client = this.delegate.create(clientName);
        this.cache.put(clientName, client);
        return client;
    }
}

