/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.IClient;
import com.netflix.client.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.RibbonClientHttpRequestFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientSpecification;
import org.springframework.cloud.netflix.ribbon.RibbonClients;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={IClient.class, RestTemplate.class})
@RibbonClients
@AutoConfigureAfter(value={EurekaClientAutoConfiguration.class})
@AutoConfigureBefore(value={LoadBalancerAutoConfiguration.class})
public class RibbonAutoConfiguration {
    @Autowired(required=false)
    private List<RibbonClientSpecification> configurations = new ArrayList<RibbonClientSpecification>();

    @Bean
    public SpringClientFactory springClientFactory() {
        SpringClientFactory factory = new SpringClientFactory();
        factory.setConfigurations(this.configurations);
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={LoadBalancerClient.class})
    public LoadBalancerClient loadBalancerClient() {
        return new RibbonLoadBalancerClient(this.springClientFactory());
    }

    @Configuration
    @ConditionalOnClass(value={HttpRequest.class})
    protected static class RibbonClientConfig {
        @Autowired
        private SpringClientFactory springClientFactory;
        @Autowired
        private LoadBalancerClient loadBalancerClient;

        protected RibbonClientConfig() {
        }

        @Bean
        public RestTemplateCustomizer restTemplateCustomizer() {
            return new RestTemplateCustomizer(){

                public void customize(RestTemplate restTemplate) {
                    restTemplate.setRequestFactory((ClientHttpRequestFactory)RibbonClientConfig.this.ribbonClientHttpRequestFactory());
                }
            };
        }

        @Bean
        public RibbonClientHttpRequestFactory ribbonClientHttpRequestFactory() {
            return new RibbonClientHttpRequestFactory(this.springClientFactory, this.loadBalancerClient);
        }
    }
}

