/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.pre.Servlet30RequestWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Servlet30WrapperFilter
extends ZuulFilter {
    private Field requestField = ReflectionUtils.findField(HttpServletRequestWrapper.class, (String)"req", HttpServletRequest.class);

    public Servlet30WrapperFilter() {
        Assert.notNull((Object)this.requestField, (String)"HttpServletRequestWrapper.req field not found");
        this.requestField.setAccessible(true);
    }

    protected Field getRequestField() {
        return this.requestField;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        if (request instanceof HttpServletRequestWrapper) {
            request = (HttpServletRequest)ReflectionUtils.getField((Field)this.requestField, (Object)request);
        }
        ctx.setRequest((HttpServletRequest)new Servlet30RequestWrapper(request));
        return null;
    }
}

