/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.web.ZuulController;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class ZuulHandlerMapping
extends AbstractUrlHandlerMapping {
    private final RouteLocator routeLocator;
    private final ZuulController zuul;
    private ErrorController errorController;

    public ZuulHandlerMapping(RouteLocator routeLocator, ZuulController zuul) {
        this.routeLocator = routeLocator;
        this.zuul = zuul;
        this.setOrder(-200);
    }

    public void setErrorController(ErrorController errorController) {
        this.errorController = errorController;
    }

    protected Object lookupHandler(String urlPath, HttpServletRequest request) throws Exception {
        if (this.errorController != null && urlPath.equals(this.errorController.getErrorPath())) {
            return null;
        }
        return super.lookupHandler(urlPath, request);
    }

    public void registerHandlers() {
        Collection<String> routes = this.routeLocator.getRoutePaths();
        if (routes.isEmpty()) {
            this.logger.warn((Object)"No routes found from ProxyRouteLocator");
        } else {
            for (String url : routes) {
                this.registerHandler(url, (Object)this.zuul);
            }
        }
    }
}

