/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.loadbalancer;

import feign.Client;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.loadbalancer.LoadBalancedRetryFactory;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.OnRetryNotEnabledCondition;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(proxyBeanMethods=false)
class DefaultFeignLoadBalancerConfiguration {
    DefaultFeignLoadBalancerConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={OnRetryNotEnabledCondition.class})
    public Client feignClient(BlockingLoadBalancerClient loadBalancerClient) {
        return new FeignBlockingLoadBalancerClient((Client)new Client.Default(null, null), loadBalancerClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.retry.support.RetryTemplate"})
    @ConditionalOnBean(value={LoadBalancedRetryFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true", matchIfMissing=true)
    public Client feignRetryClient(BlockingLoadBalancerClient loadBalancerClient, List<LoadBalancedRetryFactory> loadBalancedRetryFactories) {
        AnnotationAwareOrderComparator.sort(loadBalancedRetryFactories);
        return new RetryableFeignBlockingLoadBalancerClient((Client)new Client.Default(null, null), loadBalancerClient, loadBalancedRetryFactories.get(0));
    }
}

