/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestPart;

public class RequestPartParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestPart> ANNOTATION = RequestPart.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        int parameterIndex = context.getParameterIndex();
        MethodMetadata data = context.getMethodMetadata();
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"RequestPart.value() was empty on parameter %s", (Object[])new Object[]{parameterIndex});
        context.setParameterName(name);
        data.formParams().add(name);
        Collection<String> names = context.setTemplateParameter(name, (Collection)data.indexToName().get(parameterIndex));
        data.indexToName().put(parameterIndex, names);
        return true;
    }
}

