/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import feign.Capability;
import feign.Contract;
import feign.ExceptionPropagationPolicy;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.RequestInterceptor;
import feign.ResponseInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.openfeign.client")
public class FeignClientProperties {
    private boolean defaultToProperties = true;
    private String defaultConfig = "default";
    private Map<String, FeignClientConfiguration> config = new HashMap<String, FeignClientConfiguration>();
    private boolean decodeSlash = true;

    public boolean isDefaultToProperties() {
        return this.defaultToProperties;
    }

    public void setDefaultToProperties(boolean defaultToProperties) {
        this.defaultToProperties = defaultToProperties;
    }

    public String getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(String defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public Map<String, FeignClientConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, FeignClientConfiguration> config) {
        this.config = config;
    }

    public boolean isDecodeSlash() {
        return this.decodeSlash;
    }

    public void setDecodeSlash(boolean decodeSlash) {
        this.decodeSlash = decodeSlash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeignClientProperties that = (FeignClientProperties)o;
        return this.defaultToProperties == that.defaultToProperties && Objects.equals(this.defaultConfig, that.defaultConfig) && Objects.equals(this.config, that.config) && Objects.equals(this.decodeSlash, that.decodeSlash);
    }

    public int hashCode() {
        return Objects.hash(this.defaultToProperties, this.defaultConfig, this.config, this.decodeSlash);
    }

    public static class MicrometerProperties {
        private Boolean enabled = true;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MicrometerProperties that = (MicrometerProperties)o;
            return Objects.equals(this.enabled, that.enabled);
        }

        public int hashCode() {
            return Objects.hash(this.enabled);
        }
    }

    public static class FeignClientConfiguration {
        private Logger.Level loggerLevel;
        private Integer connectTimeout;
        private Integer readTimeout;
        private Class<Retryer> retryer;
        private Class<ErrorDecoder> errorDecoder;
        private List<Class<RequestInterceptor>> requestInterceptors;
        private Class<ResponseInterceptor> responseInterceptor;
        private Map<String, Collection<String>> defaultRequestHeaders;
        private Map<String, Collection<String>> defaultQueryParameters;
        private Boolean dismiss404;
        private Class<Decoder> decoder;
        private Class<Encoder> encoder;
        private Class<Contract> contract;
        private ExceptionPropagationPolicy exceptionPropagationPolicy;
        private List<Class<Capability>> capabilities;
        private Class<QueryMapEncoder> queryMapEncoder;
        private MicrometerProperties micrometer;
        private Boolean followRedirects;
        private String url;

        public Logger.Level getLoggerLevel() {
            return this.loggerLevel;
        }

        public void setLoggerLevel(Logger.Level loggerLevel) {
            this.loggerLevel = loggerLevel;
        }

        public Integer getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Class<Retryer> getRetryer() {
            return this.retryer;
        }

        public void setRetryer(Class<Retryer> retryer) {
            this.retryer = retryer;
        }

        public Class<ErrorDecoder> getErrorDecoder() {
            return this.errorDecoder;
        }

        public void setErrorDecoder(Class<ErrorDecoder> errorDecoder) {
            this.errorDecoder = errorDecoder;
        }

        public List<Class<RequestInterceptor>> getRequestInterceptors() {
            return this.requestInterceptors;
        }

        public void setRequestInterceptors(List<Class<RequestInterceptor>> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
        }

        public Class<ResponseInterceptor> getResponseInterceptor() {
            return this.responseInterceptor;
        }

        public void setResponseInterceptor(Class<ResponseInterceptor> responseInterceptor) {
            this.responseInterceptor = responseInterceptor;
        }

        public Map<String, Collection<String>> getDefaultRequestHeaders() {
            return this.defaultRequestHeaders;
        }

        public void setDefaultRequestHeaders(Map<String, Collection<String>> defaultRequestHeaders) {
            this.defaultRequestHeaders = defaultRequestHeaders;
        }

        public Map<String, Collection<String>> getDefaultQueryParameters() {
            return this.defaultQueryParameters;
        }

        public void setDefaultQueryParameters(Map<String, Collection<String>> defaultQueryParameters) {
            this.defaultQueryParameters = defaultQueryParameters;
        }

        public Boolean getDismiss404() {
            return this.dismiss404;
        }

        public void setDismiss404(Boolean dismiss404) {
            this.dismiss404 = dismiss404;
        }

        public Class<Decoder> getDecoder() {
            return this.decoder;
        }

        public void setDecoder(Class<Decoder> decoder) {
            this.decoder = decoder;
        }

        public Class<Encoder> getEncoder() {
            return this.encoder;
        }

        public void setEncoder(Class<Encoder> encoder) {
            this.encoder = encoder;
        }

        public Class<Contract> getContract() {
            return this.contract;
        }

        public void setContract(Class<Contract> contract) {
            this.contract = contract;
        }

        public ExceptionPropagationPolicy getExceptionPropagationPolicy() {
            return this.exceptionPropagationPolicy;
        }

        public void setExceptionPropagationPolicy(ExceptionPropagationPolicy exceptionPropagationPolicy) {
            this.exceptionPropagationPolicy = exceptionPropagationPolicy;
        }

        public List<Class<Capability>> getCapabilities() {
            return this.capabilities;
        }

        public void setCapabilities(List<Class<Capability>> capabilities) {
            this.capabilities = capabilities;
        }

        public Class<QueryMapEncoder> getQueryMapEncoder() {
            return this.queryMapEncoder;
        }

        public void setQueryMapEncoder(Class<QueryMapEncoder> queryMapEncoder) {
            this.queryMapEncoder = queryMapEncoder;
        }

        public MicrometerProperties getMicrometer() {
            return this.micrometer;
        }

        public void setMicrometer(MicrometerProperties micrometer) {
            this.micrometer = micrometer;
        }

        public Boolean isFollowRedirects() {
            return this.followRedirects;
        }

        public void setFollowRedirects(Boolean followRedirects) {
            this.followRedirects = followRedirects;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeignClientConfiguration that = (FeignClientConfiguration)o;
            return this.loggerLevel == that.loggerLevel && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.retryer, that.retryer) && Objects.equals(this.errorDecoder, that.errorDecoder) && Objects.equals(this.requestInterceptors, that.requestInterceptors) && Objects.equals(this.responseInterceptor, that.responseInterceptor) && Objects.equals(this.dismiss404, that.dismiss404) && Objects.equals(this.encoder, that.encoder) && Objects.equals(this.decoder, that.decoder) && Objects.equals(this.contract, that.contract) && Objects.equals(this.exceptionPropagationPolicy, that.exceptionPropagationPolicy) && Objects.equals(this.defaultRequestHeaders, that.defaultRequestHeaders) && Objects.equals(this.defaultQueryParameters, that.defaultQueryParameters) && Objects.equals(this.capabilities, that.capabilities) && Objects.equals(this.queryMapEncoder, that.queryMapEncoder) && Objects.equals(this.micrometer, that.micrometer) && Objects.equals(this.followRedirects, that.followRedirects) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.loggerLevel, this.connectTimeout, this.readTimeout, this.retryer, this.errorDecoder, this.requestInterceptors, this.responseInterceptor, this.dismiss404, this.encoder, this.decoder, this.contract, this.exceptionPropagationPolicy, this.defaultQueryParameters, this.defaultRequestHeaders, this.capabilities, this.queryMapEncoder, this.micrometer, this.followRedirects, this.url);
        }
    }
}

