/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.AbstractTraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingTextMap;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class TraceChannelInterceptor
extends AbstractTraceChannelInterceptor {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(TraceChannelInterceptor.class);

    @Deprecated
    public TraceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        super(tracer, traceKeys, spanExtractor, spanInjector);
    }

    public TraceChannelInterceptor(BeanFactory beanFactory) {
        super(beanFactory);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Span currentSpan = this.getTracer().getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Completed sending and current span is " + currentSpan));
        }
        if (this.containsServerReceived(currentSpan)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server send");
            }
            currentSpan.logEvent("ss");
        } else if (currentSpan != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with client received");
            }
            currentSpan.logEvent("cr");
        }
        this.addErrorTag(ex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing messaging span " + currentSpan));
        }
        this.getTracer().close(currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Messaging span " + currentSpan + " successfully closed"));
        }
    }

    private boolean containsServerReceived(Span span) {
        if (span == null) {
            return false;
        }
        for (Log log : span.logs()) {
            if (!"sr".equals(log.getEvent())) continue;
            return true;
        }
        return false;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        Span parentSpan;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing message before sending it to the channel");
        }
        Message retrievedMessage = this.getMessage(message);
        MessageBuilder messageBuilder = MessageBuilder.fromMessage((Message)retrievedMessage);
        Span span = parentSpan = this.getTracer().isTracing() ? this.getTracer().getCurrentSpan() : this.buildSpan(new MessagingTextMap(messageBuilder));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parent span is " + parentSpan));
        }
        String name = this.getMessageChannelName(channel);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Name of the span will be [" + name + "]"));
        }
        Span span2 = this.startSpan(parentSpan, name, message);
        if (message.getHeaders().containsKey((Object)"messageSent")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server received");
            }
            span2.logEvent("sr");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with client send");
            }
            span2.logEvent("cs");
            messageBuilder.setHeader("messageSent", (Object)true);
        }
        this.getSpanInjector().inject(span2, new MessagingTextMap(messageBuilder));
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.copyHeaders((Map)messageBuilder.build().getHeaders());
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Message getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            return e.getFailedMessage();
        }
        return message;
    }

    private Span startSpan(Span span, String name, Message<?> message) {
        if (span != null) {
            return this.getTracer().createSpan(name, span);
        }
        if ("0".equals(message.getHeaders().get((Object)"spanSampled"))) {
            return this.getTracer().createSpan(name, NeverSampler.INSTANCE);
        }
        return this.getTracer().createSpan(name);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        Span spanFromHeader = this.getTracer().getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Continuing span " + spanFromHeader + " before handling message"));
        }
        if (spanFromHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server received");
            }
            spanFromHeader.logEvent("sr");
        }
        this.getTracer().continueSpan(spanFromHeader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span " + spanFromHeader + " successfully continued"));
        }
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        Span spanFromHeader = this.getTracer().getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Continuing span " + spanFromHeader + " after message handled"));
        }
        if (spanFromHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marking span with server send");
            }
            spanFromHeader.logEvent("ss");
            this.addErrorTag(ex);
        }
        if (this.getTracer().isTracing()) {
            this.getTracer().detach(spanFromHeader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detached " + spanFromHeader + " from current thread"));
            }
        }
    }

    private void addErrorTag(Exception ex) {
        if (ex != null) {
            this.getErrorParser().parseErrorTags(this.getTracer().getCurrentSpan(), ex);
        }
    }
}

