/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

class HttpRequestTextMap
implements SpanTextMap {
    private final HttpRequest delegate;

    HttpRequestTextMap(HttpRequest delegate) {
        this.delegate = delegate;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        final Iterator iterator = this.delegate.getHeaders().entrySet().iterator();
        return new Iterator<Map.Entry<String, String>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<String, String> next() {
                Map.Entry next = (Map.Entry)iterator.next();
                List value = (List)next.getValue();
                return new AbstractMap.SimpleEntry<String, String>((String)next.getKey(), value.isEmpty() ? "" : (String)value.get(0));
            }
        };
    }

    @Override
    public void put(String key, String value) {
        if (!StringUtils.hasText((String)value)) {
            return;
        }
        this.delegate.getHeaders().put(key, Collections.singletonList(value));
    }
}

