/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.io.IOException;
import java.net.URI;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractTraceHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceAsyncListenableTaskExecutor;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class TraceAsyncClientHttpRequestFactoryWrapper
extends AbstractTraceHttpRequestInterceptor
implements ClientHttpRequestFactory,
AsyncClientHttpRequestFactory {
    final AsyncClientHttpRequestFactory asyncDelegate;
    final ClientHttpRequestFactory syncDelegate;

    public TraceAsyncClientHttpRequestFactoryWrapper(Tracer tracer, HttpSpanInjector spanInjector, AsyncClientHttpRequestFactory asyncDelegate, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(tracer, spanInjector, httpTraceKeysInjector);
        this.asyncDelegate = asyncDelegate;
        this.syncDelegate = asyncDelegate instanceof ClientHttpRequestFactory ? (ClientHttpRequestFactory)asyncDelegate : this.defaultClientHttpRequestFactory();
    }

    public TraceAsyncClientHttpRequestFactoryWrapper(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(tracer, spanInjector, httpTraceKeysInjector);
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = this.defaultClientHttpRequestFactory();
        this.asyncDelegate = simpleClientHttpRequestFactory;
        this.syncDelegate = simpleClientHttpRequestFactory;
    }

    public TraceAsyncClientHttpRequestFactoryWrapper(Tracer tracer, HttpSpanInjector spanInjector, AsyncClientHttpRequestFactory asyncDelegate, ClientHttpRequestFactory syncDelegate, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(tracer, spanInjector, httpTraceKeysInjector);
        this.asyncDelegate = asyncDelegate;
        this.syncDelegate = syncDelegate;
    }

    private SimpleClientHttpRequestFactory defaultClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setTaskExecutor(this.asyncListenableTaskExecutor(this.tracer));
        return simpleClientHttpRequestFactory;
    }

    private AsyncListenableTaskExecutor asyncListenableTaskExecutor(Tracer tracer) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.initialize();
        return new TraceAsyncListenableTaskExecutor((AsyncListenableTaskExecutor)threadPoolTaskScheduler, tracer);
    }

    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) throws IOException {
        AsyncClientHttpRequest request = this.asyncDelegate.createAsyncRequest(uri, httpMethod);
        this.addRequestTags((HttpRequest)request);
        this.publishStartEvent((HttpRequest)request);
        return request;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        ClientHttpRequest request = this.syncDelegate.createRequest(uri, httpMethod);
        this.addRequestTags((HttpRequest)request);
        this.publishStartEvent((HttpRequest)request);
        return request;
    }
}

