/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class TraceAsyncListenableTaskExecutor
implements AsyncListenableTaskExecutor {
    private final AsyncListenableTaskExecutor delegate;
    private final Tracer tracer;

    TraceAsyncListenableTaskExecutor(AsyncListenableTaskExecutor delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable(this.tracer.wrap(task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(this.tracer.wrap(task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute(this.tracer.wrap(task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.tracer.wrap(task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.tracer.wrap(task));
    }

    public void execute(Runnable task) {
        this.delegate.execute(this.tracer.wrap(task));
    }
}

