/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.io.IOException;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.ExceptionMessageErrorParser;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractTraceHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.TraceHttpResponse;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TraceRestTemplateInterceptor
extends AbstractTraceHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final ErrorParser errorParser;

    @Deprecated
    public TraceRestTemplateInterceptor(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        super(tracer, spanInjector, httpTraceKeysInjector);
        this.errorParser = new ExceptionMessageErrorParser();
    }

    public TraceRestTemplateInterceptor(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector, ErrorParser errorParser) {
        super(tracer, spanInjector, httpTraceKeysInjector);
        this.errorParser = errorParser;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.publishStartEvent(request);
        return this.response(request, body, execution);
    }

    private ClientHttpResponse response(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            return new TraceHttpResponse(this, execution.execute(request, body));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception occurred while trying to execute the request. Will close the span [" + this.currentSpan() + "]"), (Throwable)e);
            }
            this.errorParser.parseErrorTags(this.currentSpan(), e);
            this.finish();
            throw e;
        }
    }
}

