/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignClient;

@Aspect
class TraceFeignAspect {
    private final BeanFactory beanFactory;

    TraceFeignAspect(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Around(value="execution (* feign.Client.*(..)) && !within(is(FinalType))")
    public Object feignClientWasCalled(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        Request request = (Request)args[0];
        Request.Options options = (Request.Options)args[1];
        Object bean = pjp.getTarget();
        if (!(bean instanceof TraceFeignClient)) {
            return new TraceFeignClient(this.beanFactory, (Client)bean).execute(request, options);
        }
        return pjp.proceed();
    }
}

