/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestTextMap;
import org.springframework.cloud.sleuth.util.SpanNameUtil;

class TraceFeignClient
implements Client {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Client delegate;
    private HttpTraceKeysInjector keysInjector;
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private HttpSpanInjector spanInjector;
    private ErrorParser errorParser;

    TraceFeignClient(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.delegate = this.client(beanFactory);
    }

    private Client client(BeanFactory beanFactory) {
        try {
            return (Client)beanFactory.getBean(Client.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new Client.Default(null, null);
        }
    }

    TraceFeignClient(BeanFactory beanFactory, Client delegate) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        String spanName = this.getSpanName(request);
        Span span = this.getTracer().createSpan(spanName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new Feign span " + span));
        }
        try {
            AtomicReference<Request> feignRequest = new AtomicReference<Request>(request);
            this.spanInjector().inject(span, new FeignRequestTextMap(feignRequest));
            span.logEvent("cs");
            this.addRequestTags(request);
            Request modifiedRequest = feignRequest.get();
            if (log.isDebugEnabled()) {
                log.debug((Object)("The modified request equals " + modifiedRequest));
            }
            Response response = this.delegate.execute(modifiedRequest, options);
            this.logCr();
            Response response2 = response;
            return response2;
        }
        catch (IOException | RuntimeException e) {
            this.logCr();
            this.logError(e);
            throw e;
        }
        finally {
            this.closeSpan(span);
        }
    }

    private String getSpanName(Request request) {
        URI uri = URI.create(request.url());
        return SpanNameUtil.shorten(this.uriScheme(uri) + ":" + uri.getPath());
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    private void addRequestTags(Request request) {
        URI uri = URI.create(request.url());
        this.keysInjector().addRequestTags(uri.toString(), uri.getHost(), uri.getPath(), request.method(), request.headers());
    }

    private HttpTraceKeysInjector keysInjector() {
        if (this.keysInjector == null) {
            this.keysInjector = (HttpTraceKeysInjector)this.beanFactory.getBean(HttpTraceKeysInjector.class);
        }
        return this.keysInjector;
    }

    private HttpSpanInjector spanInjector() {
        if (this.spanInjector == null) {
            this.spanInjector = (HttpSpanInjector)this.beanFactory.getBean(HttpSpanInjector.class);
        }
        return this.spanInjector;
    }

    private void closeSpan(Span span) {
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing Feign span " + span));
            }
            this.getTracer().close(span);
        }
    }

    private void logCr() {
        Span span = this.getTracer().getCurrentSpan();
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing Feign span and logging CR " + span));
            }
            span.logEvent("cr");
        }
    }

    private void logError(Exception e) {
        Span span = this.getTracer().getCurrentSpan();
        if (span != null) {
            this.getErrorParser().parseErrorTags(span, e);
        }
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private ErrorParser getErrorParser() {
        if (this.errorParser == null) {
            this.errorParser = (ErrorParser)this.beanFactory.getBean(ErrorParser.class);
        }
        return this.errorParser;
    }
}

