/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignContext;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignObjectWrapper;

class TraceFeignContext
extends FeignContext {
    private final TraceFeignObjectWrapper traceFeignObjectWrapper;
    private final FeignContext delegate;

    TraceFeignContext(TraceFeignObjectWrapper traceFeignObjectWrapper, FeignContext delegate) {
        this.traceFeignObjectWrapper = traceFeignObjectWrapper;
        this.delegate = delegate;
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegate.getInstance(name, type);
        return (T)this.traceFeignObjectWrapper.wrap(object);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        HashMap convertedInstances = new HashMap();
        for (Map.Entry entry : instances.entrySet()) {
            convertedInstances.put(entry.getKey(), this.traceFeignObjectWrapper.wrap(entry.getValue()));
        }
        return convertedInstances;
    }
}

