/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommand;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandContext;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;

class TraceRibbonCommandFactory
implements RibbonCommandFactory {
    private final RibbonCommandFactory delegate;
    private final Tracer tracer;
    private final HttpTraceKeysInjector httpTraceKeysInjector;

    public TraceRibbonCommandFactory(RibbonCommandFactory delegate, Tracer tracer, HttpTraceKeysInjector httpTraceKeysInjector) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
    }

    public RibbonCommand create(RibbonCommandContext context) {
        RibbonCommand ribbonCommand = this.delegate.create(context);
        Span span = this.tracer.getCurrentSpan();
        this.httpTraceKeysInjector.addRequestTags(span, context.uri(), context.getMethod());
        return ribbonCommand;
    }
}

