/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.zuul.filters.route.RibbonCommandFactory;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.zuul.TraceRibbonCommandFactory;

final class TraceRibbonCommandFactoryBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private HttpTraceKeysInjector httpTraceKeysInjector;

    TraceRibbonCommandFactoryBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RibbonCommandFactory) {
            return new TraceRibbonCommandFactory((RibbonCommandFactory)bean, this.getTracer(), this.getHttpTraceKeysInjector());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    HttpTraceKeysInjector getHttpTraceKeysInjector() {
        if (this.httpTraceKeysInjector == null) {
            this.httpTraceKeysInjector = (HttpTraceKeysInjector)this.beanFactory.getBean(HttpTraceKeysInjector.class);
        }
        return this.httpTraceKeysInjector;
    }
}

