/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.CurrentSpanCustomizer;
import brave.ErrorParser;
import brave.Tracer;
import brave.Tracing;
import brave.handler.FinishedSpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.sampler.Sampler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import zipkin2.Span;
import zipkin2.reporter.InMemoryReporterMetrics;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthProperties.class})
public class TraceAutoConfiguration {
    public static final String TRACER_BEAN_NAME = "tracer";
    public static final String DEFAULT_SERVICE_NAME = "default";
    @Autowired(required=false)
    List<Reporter<Span>> spanReporters = new ArrayList<Reporter<Span>>();
    @Autowired(required=false)
    List<SpanAdjuster> spanAdjusters = new ArrayList<SpanAdjuster>();
    @Autowired(required=false)
    List<FinishedSpanHandler> finishedSpanHandlers = new ArrayList<FinishedSpanHandler>();
    @Autowired(required=false)
    List<CurrentTraceContext.ScopeDecorator> scopeDecorators = new ArrayList<CurrentTraceContext.ScopeDecorator>();
    @Autowired(required=false)
    ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder;

    @Bean
    @ConditionalOnMissingBean
    Tracing tracing(@Value(value="${spring.zipkin.service.name:${spring.application.name:default}}") String serviceName, Propagation.Factory factory, CurrentTraceContext currentTraceContext, Sampler sampler, ErrorParser errorParser, SleuthProperties sleuthProperties) {
        Tracing.Builder builder = Tracing.newBuilder().sampler(sampler).errorParser(errorParser).localServiceName(StringUtils.isEmpty((Object)serviceName) ? DEFAULT_SERVICE_NAME : serviceName).propagationFactory(factory).currentTraceContext(currentTraceContext).spanReporter((Reporter)new CompositeReporter(this.spanAdjusters, this.spanReporters)).traceId128Bit(sleuthProperties.isTraceId128()).supportsJoin(sleuthProperties.isSupportsJoin());
        for (FinishedSpanHandler finishedSpanHandlerFactory : this.finishedSpanHandlers) {
            builder.addFinishedSpanHandler(finishedSpanHandlerFactory);
        }
        return builder.build();
    }

    @Bean(name={"tracer"})
    @ConditionalOnMissingBean
    Tracer tracer(Tracing tracing) {
        return tracing.tracer();
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler sleuthTraceSampler() {
        return Sampler.NEVER_SAMPLE;
    }

    @Bean
    @ConditionalOnMissingBean
    SpanNamer sleuthSpanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Factory sleuthPropagation(SleuthProperties sleuthProperties) {
        if (sleuthProperties.getBaggageKeys().isEmpty() && sleuthProperties.getPropagationKeys().isEmpty()) {
            return B3Propagation.FACTORY;
        }
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = this.extraFieldPropagationFactoryBuilder != null ? this.extraFieldPropagationFactoryBuilder : ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!sleuthProperties.getBaggageKeys().isEmpty()) {
            factoryBuilder = factoryBuilder.addPrefixedFields("baggage-", sleuthProperties.getBaggageKeys()).addPrefixedFields("baggage_", sleuthProperties.getBaggageKeys());
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key : sleuthProperties.getPropagationKeys()) {
                factoryBuilder = factoryBuilder.addField(key);
            }
        }
        return factoryBuilder.build();
    }

    @Bean
    CurrentTraceContext sleuthCurrentTraceContext(CurrentTraceContext.Builder builder) {
        for (CurrentTraceContext.ScopeDecorator scopeDecorator : this.scopeDecorators) {
            builder.addScopeDecorator(scopeDecorator);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentTraceContext.Builder sleuthCurrentTraceContextBuilder() {
        return ThreadLocalCurrentTraceContext.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean
    ReporterMetrics sleuthReporterMetrics() {
        return new InMemoryReporterMetrics();
    }

    @Bean
    @ConditionalOnMissingBean
    Reporter<Span> noOpSpanReporter() {
        return Reporter.NOOP;
    }

    @Bean
    @ConditionalOnMissingBean
    ErrorParser errorParser() {
        return new ErrorParser();
    }

    @Bean
    @ConditionalOnMissingBean
    CurrentSpanCustomizer spanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    private static class CompositeReporter
    implements Reporter<Span> {
        private static final Log log = LogFactory.getLog(CompositeReporter.class);
        private final List<SpanAdjuster> spanAdjusters;
        private final Reporter<Span> spanReporter;

        private CompositeReporter(List<SpanAdjuster> spanAdjusters, List<Reporter<Span>> spanReporters) {
            Reporter<Span> reporter;
            this.spanAdjusters = spanAdjusters;
            if (spanReporters.size() == 1) {
                reporter = spanReporters.get(0);
            } else {
                Reporter<Span> reporter2;
                reporter = reporter2;
                super(spanReporters);
            }
            this.spanReporter = reporter;
        }

        public void report(Span span) {
            Span spanToAdjust = span;
            for (SpanAdjuster spanAdjuster : this.spanAdjusters) {
                spanToAdjust = spanAdjuster.adjust(spanToAdjust);
            }
            this.spanReporter.report((Object)spanToAdjust);
        }

        public String toString() {
            return "CompositeReporter{spanAdjusters=" + this.spanAdjusters + ", spanReporters=" + this.spanReporter + '}';
        }

        private static class ListReporter
        implements Reporter<Span> {
            private final List<Reporter<Span>> spanReporters;

            private ListReporter(List<Reporter<Span>> spanReporters) {
                this.spanReporters = spanReporters;
            }

            public void report(Span span) {
                for (Reporter<Span> spanReporter : this.spanReporters) {
                    try {
                        spanReporter.report((Object)span);
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Exception occurred while trying to report the span " + span), (Throwable)ex);
                    }
                }
            }

            public String toString() {
                return "ListReporter{spanReporters=" + this.spanReporters + '}';
            }
        }
    }
}

