/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracer;
import brave.Tracing;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.ExecutorBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.TraceAsyncAspect;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.async.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
public class AsyncDefaultAutoConfiguration {
    @Bean
    public static ExecutorBeanPostProcessor executorBeanPostProcessor(BeanFactory beanFactory) {
        return new ExecutorBeanPostProcessor(beanFactory);
    }

    @Bean
    public TraceAsyncAspect traceAsyncAspect(Tracer tracer, SpanNamer spanNamer) {
        return new TraceAsyncAspect(tracer, spanNamer);
    }

    @Configuration
    @ConditionalOnMissingBean(value={AsyncConfigurer.class})
    @ConditionalOnProperty(value={"spring.sleuth.async.configurer.enabled"}, matchIfMissing=true)
    @Role(value=2)
    static class DefaultAsyncConfigurerSupport
    extends AsyncConfigurerSupport {
        @Autowired
        private BeanFactory beanFactory;

        DefaultAsyncConfigurerSupport() {
        }

        public Executor getAsyncExecutor() {
            return new LazyTraceExecutor(this.beanFactory, (Executor)new SimpleAsyncTaskExecutor());
        }
    }
}

