/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.hystrix;

import brave.Span;
import brave.Tracer;
import com.netflix.hystrix.HystrixCommand;
import java.util.concurrent.atomic.AtomicReference;

public abstract class TraceCommand<R>
extends HystrixCommand<R> {
    private static final String COMMAND_KEY = "commandKey";
    private static final String COMMAND_GROUP_KEY = "commandGroup";
    private static final String THREAD_POOL_KEY = "threadPoolKey";
    private static final String FALLBACK_METHOD_NAME_KEY = "fallbackMethodName";
    private final Tracer tracer;
    private final AtomicReference<Span> span;

    protected TraceCommand(Tracer tracer, HystrixCommand.Setter setter) {
        super(setter);
        this.tracer = tracer;
        this.span = new AtomicReference<Span>(this.tracer.nextSpan());
    }

    /*
     * Exception decompiling
     */
    protected R run() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract R doRun() throws Exception;

    /*
     * Loose catch block
     */
    protected R getFallback() {
        Span span = this.span.get();
        try {
            R r;
            try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);){
                span.tag(FALLBACK_METHOD_NAME_KEY, this.getFallbackMethodName());
                r = this.doGetFallback();
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
            this.span.set(null);
        }
    }

    public R doGetFallback() {
        return (R)super.getFallback();
    }
}

