/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.Tracer;
import brave.Tracing;
import brave.jms.JmsTracing;
import brave.kafka.clients.KafkaTracing;
import brave.propagation.CurrentTraceContext;
import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.messaging.OnMessagingEnabled;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthKafkaAspect;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthMessagingProperties;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthRabbitBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.TracingConnectionFactoryBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.messaging.TracingJmsListenerEndpointRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@OnMessagingEnabled
@EnableConfigurationProperties(value={SleuthMessagingProperties.class})
public class TraceMessagingAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.messaging.jms.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={JmsListenerConfigurer.class})
    @Role(value=2)
    protected static class SleuthJmsConfiguration {
        protected SleuthJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        JmsTracing jmsTracing(Tracing tracing, SleuthMessagingProperties properties) {
            return JmsTracing.newBuilder((Tracing)tracing).remoteServiceName(properties.getMessaging().getJms().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        TracingConnectionFactoryBeanPostProcessor tracingConnectionFactoryBeanPostProcessor(BeanFactory beanFactory) {
            return new TracingConnectionFactoryBeanPostProcessor(beanFactory);
        }

        @Bean
        JmsListenerConfigurer configureTracing(JmsTracing jmsTracing, CurrentTraceContext current) {
            return registrar -> registrar.setEndpointRegistry((JmsListenerEndpointRegistry)new TracingJmsListenerEndpointRegistry(jmsTracing, current));
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.messaging.kafka.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={ProducerFactory.class})
    protected static class SleuthKafkaConfiguration {
        protected SleuthKafkaConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        KafkaTracing kafkaTracing(Tracing tracing, SleuthMessagingProperties properties) {
            return KafkaTracing.newBuilder((Tracing)tracing).remoteServiceName(properties.getMessaging().getKafka().getRemoteServiceName()).build();
        }

        @Bean
        @ConditionalOnMissingBean
        SleuthKafkaAspect sleuthKafkaAspect(KafkaTracing kafkaTracing, Tracer tracer) {
            return new SleuthKafkaAspect(kafkaTracing, tracer);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.messaging.rabbit.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={RabbitTemplate.class})
    protected static class SleuthRabbitConfiguration {
        protected SleuthRabbitConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        static SleuthRabbitBeanPostProcessor sleuthRabbitBeanPostProcessor(BeanFactory beanFactory) {
            return new SleuthRabbitBeanPostProcessor(beanFactory);
        }

        @Bean
        @ConditionalOnMissingBean
        SpringRabbitTracing springRabbitTracing(Tracing tracing, SleuthMessagingProperties properties) {
            return SpringRabbitTracing.newBuilder((Tracing)tracing).remoteServiceName(properties.getMessaging().getRabbit().getRemoteServiceName()).build();
        }
    }
}

