/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.jms.JmsTracing;
import brave.propagation.CurrentTraceContext;
import java.lang.reflect.Field;
import javax.jms.MessageListener;
import org.springframework.cloud.sleuth.instrument.messaging.TracingMessagingMessageListenerAdapter;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.MethodJmsListenerEndpoint;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.util.StringValueResolver;

class TracingJmsListenerEndpointRegistry
extends JmsListenerEndpointRegistry {
    final JmsTracing jmsTracing;
    final CurrentTraceContext current;
    final Field messageHandlerMethodFactoryField;
    final Field embeddedValueResolverField;

    TracingJmsListenerEndpointRegistry(JmsTracing jmsTracing, CurrentTraceContext current) {
        this.jmsTracing = jmsTracing;
        this.current = current;
        this.messageHandlerMethodFactoryField = TracingJmsListenerEndpointRegistry.tryField("messageHandlerMethodFactory");
        this.embeddedValueResolverField = TracingJmsListenerEndpointRegistry.tryField("embeddedValueResolver");
    }

    @Nullable
    static Field tryField(String name) {
        try {
            Field field = MethodJmsListenerEndpoint.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    static <T> T get(Object object, Field field) throws IllegalAccessException {
        return (T)field.get(object);
    }

    public void registerListenerContainer(JmsListenerEndpoint endpoint, JmsListenerContainerFactory<?> factory, boolean startImmediately) {
        if (endpoint instanceof MethodJmsListenerEndpoint) {
            endpoint = this.trace((MethodJmsListenerEndpoint)endpoint);
        } else if (endpoint instanceof SimpleJmsListenerEndpoint) {
            endpoint = this.trace((SimpleJmsListenerEndpoint)endpoint);
        }
        super.registerListenerContainer(endpoint, factory, startImmediately);
    }

    SimpleJmsListenerEndpoint trace(SimpleJmsListenerEndpoint source) {
        MessageListener delegate = source.getMessageListener();
        if (delegate == null) {
            return source;
        }
        source.setMessageListener(this.jmsTracing.messageListener(delegate, false));
        return source;
    }

    MethodJmsListenerEndpoint trace(MethodJmsListenerEndpoint source) {
        if (this.messageHandlerMethodFactoryField == null || this.embeddedValueResolverField == null) {
            return source;
        }
        MethodJmsListenerEndpoint dest = new MethodJmsListenerEndpoint(){

            protected MessagingMessageListenerAdapter createMessageListenerInstance() {
                return new TracingMessagingMessageListenerAdapter(TracingJmsListenerEndpointRegistry.this.jmsTracing, TracingJmsListenerEndpointRegistry.this.current);
            }
        };
        dest.setId(source.getId());
        dest.setDestination(source.getDestination());
        dest.setSubscription(source.getSubscription());
        dest.setSelector(source.getSelector());
        dest.setConcurrency(source.getConcurrency());
        dest.setBean(source.getBean());
        dest.setMethod(source.getMethod());
        dest.setMostSpecificMethod(source.getMostSpecificMethod());
        try {
            dest.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)TracingJmsListenerEndpointRegistry.get(source, this.messageHandlerMethodFactoryField));
            dest.setEmbeddedValueResolver((StringValueResolver)TracingJmsListenerEndpointRegistry.get(source, this.embeddedValueResolverField));
        }
        catch (IllegalAccessException e) {
            return source;
        }
        return dest;
    }
}

