/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.SingleSkipPattern;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthWebProperties.class})
public class TraceWebAutoConfiguration {
    @Autowired(required=false)
    List<SingleSkipPattern> patterns = new ArrayList<SingleSkipPattern>();

    @Bean
    @ConditionalOnMissingBean
    SkipPatternProvider sleuthSkipPatternProvider() {
        return () -> Pattern.compile(this.patterns.stream().map(SingleSkipPattern::skipPattern).filter(Optional::isPresent).map(Optional::get).map(Pattern::pattern).collect(Collectors.joining("|")));
    }

    @Configuration
    static class DefaultSkipPatternConfig {
        DefaultSkipPatternConfig() {
        }

        private static String combinedPattern(String skipPattern, String additionalSkipPattern) {
            String pattern = skipPattern;
            if (!StringUtils.hasText((String)skipPattern)) {
                pattern = "/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream|/application/.*|/actuator.*|/cloudfoundryapplication";
            }
            if (StringUtils.hasText((String)additionalSkipPattern)) {
                return pattern + "|" + additionalSkipPattern;
            }
            return pattern;
        }

        @Bean
        SingleSkipPattern defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
            return () -> Optional.of(Pattern.compile(DefaultSkipPatternConfig.combinedPattern(sleuthWebProperties.getSkipPattern(), sleuthWebProperties.getAdditionalSkipPattern())));
        }
    }

    @Configuration
    @ConditionalOnClass(value={ServerProperties.class, WebEndpointProperties.class})
    protected static class ServerSkipPatternProviderConfig {
        protected ServerSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForServerProperties(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties) {
            String contextPath = serverProperties.getServlet().getContextPath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(contextPath + webEndpointProperties.getBasePath() + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ServerProperties.class, WebEndpointProperties.class})
        public SingleSkipPattern skipPatternForServerProperties(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties) {
            return () -> ServerSkipPatternProviderConfig.getPatternForServerProperties(serverProperties, webEndpointProperties);
        }
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    protected static class ManagementSkipPatternProviderConfig {
        protected ManagementSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            String contextPath = managementServerProperties.getServlet().getContextPath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(contextPath + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SingleSkipPattern skipPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            return () -> ManagementSkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties);
        }
    }
}

