/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.List;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;

abstract class AbstractHttpHeadersFilter
implements HttpHeadersFilter {
    static final String SPAN_ATTRIBUTE = Span.class.getName();
    private static final Propagation.Setter<ServerHttpRequest.Builder, String> SETTER = new Propagation.Setter<ServerHttpRequest.Builder, String>(){

        public void put(ServerHttpRequest.Builder carrier, String key, String value) {
            carrier.headers(httpHeaders -> httpHeaders.set(key, value));
        }

        public String toString() {
            return "ServerHttpRequest.Builder::header";
        }
    };
    final Tracer tracer;
    final HttpClientHandler<ServerHttpRequest.Builder, ServerHttpResponse> handler;
    final TraceContext.Injector<ServerHttpRequest.Builder> injector;
    final HttpTracing httpTracing;

    AbstractHttpHeadersFilter(HttpTracing httpTracing) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new ServerHttpAdapter());
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.httpTracing = httpTracing;
    }

    private static class ServerHttpAdapter
    extends HttpClientAdapter<ServerHttpRequest.Builder, ServerHttpResponse> {
        private ServerHttpAdapter() {
        }

        public String method(ServerHttpRequest.Builder request) {
            return request.build().getMethodValue();
        }

        public String url(ServerHttpRequest.Builder request) {
            return request.build().getURI().toString();
        }

        public String requestHeader(ServerHttpRequest.Builder request, String name) {
            List result = request.build().getHeaders().get((Object)name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(ServerHttpResponse response) {
            return response.getStatusCode() != null ? Integer.valueOf(response.getStatusCode().value()) : null;
        }
    }
}

