/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

class HttpClientBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    HttpClientBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof HttpClient) {
            return ((HttpClient)bean).mapConnect((BiFunction)new TracingMapConnect(this.beanFactory)).doOnRequest((BiConsumer)TracingDoOnRequest.create(this.beanFactory)).doOnRequestError((BiConsumer)TracingDoOnErrorRequest.create(this.beanFactory)).doOnResponse((BiConsumer)TracingDoOnResponse.create(this.beanFactory)).doOnResponseError((BiConsumer)TracingDoOnErrorResponse.create(this.beanFactory));
        }
        return bean;
    }

    private static class HttpAdapter
    extends HttpClientAdapter<HttpClientRequest, HttpClientResponse> {
        private HttpAdapter() {
        }

        public String method(HttpClientRequest request) {
            return request.method().name();
        }

        public String url(HttpClientRequest request) {
            return request.uri();
        }

        public String requestHeader(HttpClientRequest request, String name) {
            String result = request.requestHeaders().get(name);
            return result != null ? result.toString() : "";
        }

        public Integer statusCode(HttpClientResponse response) {
            return response.status().code();
        }
    }

    private static abstract class AbstractTracingDoOnHandler {
        final Tracer tracer;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;

        AbstractTracingDoOnHandler(HttpTracing httpTracing) {
            this.tracer = httpTracing.tracing().tracer();
            this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
        }

        protected void handle(HttpClientResponse httpClientResponse, Throwable throwable) {
            AtomicReference reference = (AtomicReference)httpClientResponse.currentContext().getOrDefault(AtomicReference.class, null);
            if (reference == null || reference.get() == null) {
                return;
            }
            this.handler.handleReceive((Object)httpClientResponse, throwable, (Span)reference.get());
        }
    }

    private static class TracingDoOnErrorResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Throwable> {
        TracingDoOnErrorResponse(HttpTracing httpTracing) {
            super(httpTracing);
        }

        static TracingDoOnErrorResponse create(BeanFactory beanFactory) {
            return new TracingDoOnErrorResponse((HttpTracing)beanFactory.getBean(HttpTracing.class));
        }

        @Override
        public void accept(HttpClientResponse httpClientResponse, Throwable throwable) {
            this.handle(httpClientResponse, throwable);
        }
    }

    private static class TracingDoOnErrorRequest
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientRequest, Throwable> {
        TracingDoOnErrorRequest(HttpTracing httpTracing) {
            super(httpTracing);
        }

        static TracingDoOnErrorRequest create(BeanFactory beanFactory) {
            return new TracingDoOnErrorRequest((HttpTracing)beanFactory.getBean(HttpTracing.class));
        }

        @Override
        public void accept(HttpClientRequest request, Throwable throwable) {
            this.handle(null, throwable);
        }
    }

    private static class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientResponse, Connection> {
        TracingDoOnResponse(HttpTracing httpTracing) {
            super(httpTracing);
        }

        static TracingDoOnResponse create(BeanFactory beanFactory) {
            return new TracingDoOnResponse((HttpTracing)beanFactory.getBean(HttpTracing.class));
        }

        @Override
        public void accept(HttpClientResponse httpClientResponse, Connection connection) {
            this.handle(httpClientResponse, null);
        }
    }

    private static class TracingDoOnRequest
    implements BiConsumer<HttpClientRequest, Connection> {
        static final Propagation.Setter<HttpHeaders, String> SETTER = new Propagation.Setter<HttpHeaders, String>(){

            public void put(HttpHeaders carrier, String key, String value) {
                if (!carrier.contains(key)) {
                    carrier.add(key, (Object)value);
                }
            }

            public String toString() {
                return "HttpHeaders::add";
            }
        };
        final Tracer tracer;
        final HttpClientHandler<HttpClientRequest, HttpClientResponse> handler;
        final TraceContext.Injector<HttpHeaders> injector;
        final HttpTracing httpTracing;
        final Propagation<String> propagation;

        TracingDoOnRequest(HttpTracing httpTracing) {
            this.tracer = httpTracing.tracing().tracer();
            this.handler = HttpClientHandler.create((HttpTracing)httpTracing, (HttpClientAdapter)new HttpAdapter());
            this.propagation = httpTracing.tracing().propagation();
            this.injector = this.propagation.injector(SETTER);
            this.httpTracing = httpTracing;
        }

        static TracingDoOnRequest create(BeanFactory beanFactory) {
            return new TracingDoOnRequest((HttpTracing)beanFactory.getBean(HttpTracing.class));
        }

        @Override
        public void accept(HttpClientRequest req, Connection connection) {
            if (this.propagation.keys().stream().anyMatch(key -> req.requestHeaders().contains(key))) {
                return;
            }
            AtomicReference reference = (AtomicReference)req.currentContext().getOrDefault(AtomicReference.class, new AtomicReference());
            Span span = this.handler.handleSend(this.injector, (Object)req.requestHeaders(), (Object)req, (Span)reference.get());
            reference.set(span);
        }
    }

    private static class TracingMapConnect
    implements BiFunction<Mono<? extends Connection>, Bootstrap, Mono<? extends Connection>> {
        private final BeanFactory beanFactory;
        private Tracer tracer;

        TracingMapConnect(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono, Bootstrap bootstrap) {
            return mono.subscriberContext(context -> context.put(AtomicReference.class, new AtomicReference<Span>(this.tracer().currentSpan())));
        }

        private Tracer tracer() {
            if (this.tracer == null) {
                this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
            }
            return this.tracer;
        }
    }
}

