/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import java.util.AbstractMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.log.SleuthSlf4jProperties;
import org.springframework.util.StringUtils;

final class Slf4jScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    private static final String LEGACY_EXPORTABLE_NAME = "X-Span-Export";
    private static final String LEGACY_PARENT_ID_NAME = "X-B3-ParentSpanId";
    private static final String LEGACY_TRACE_ID_NAME = "X-B3-TraceId";
    private static final String LEGACY_SPAN_ID_NAME = "X-B3-SpanId";
    private static final Logger log = LoggerFactory.getLogger(Slf4jScopeDecorator.class);
    private final SleuthProperties sleuthProperties;
    private final SleuthSlf4jProperties sleuthSlf4jProperties;

    Slf4jScopeDecorator(SleuthProperties sleuthProperties, SleuthSlf4jProperties sleuthSlf4jProperties) {
        this.sleuthProperties = sleuthProperties;
        this.sleuthSlf4jProperties = sleuthSlf4jProperties;
    }

    public CurrentTraceContext.Scope decorateScope(final TraceContext currentSpan, final CurrentTraceContext.Scope scope) {
        final String previousTraceId = MDC.get((String)"traceId");
        final String previousParentId = MDC.get((String)"parentId");
        final String previousSpanId = MDC.get((String)"spanId");
        final String spanExportable = MDC.get((String)"spanExportable");
        final String legacyPreviousTraceId = MDC.get((String)LEGACY_TRACE_ID_NAME);
        final String legacyPreviousParentId = MDC.get((String)LEGACY_PARENT_ID_NAME);
        final String legacyPreviousSpanId = MDC.get((String)LEGACY_SPAN_ID_NAME);
        final String legacySpanExportable = MDC.get((String)LEGACY_EXPORTABLE_NAME);
        final List previousMdc = Stream.concat(this.whitelistedBaggageKeysWithValue(currentSpan), this.whitelistedPropagationKeysWithValue(currentSpan)).map(s -> new AbstractMap.SimpleEntry<String, String>((String)s, MDC.get((String)s))).collect(Collectors.toList());
        if (currentSpan != null) {
            String traceIdString = currentSpan.traceIdString();
            MDC.put((String)"traceId", (String)traceIdString);
            MDC.put((String)LEGACY_TRACE_ID_NAME, (String)traceIdString);
            String parentId = currentSpan.parentId() != null ? HexCodec.toLowerHex((long)currentSpan.parentId()) : null;
            Slf4jScopeDecorator.replace("parentId", parentId);
            Slf4jScopeDecorator.replace(LEGACY_PARENT_ID_NAME, parentId);
            String spanId = HexCodec.toLowerHex((long)currentSpan.spanId());
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)LEGACY_SPAN_ID_NAME, (String)spanId);
            String sampled = String.valueOf(currentSpan.sampled());
            MDC.put((String)"spanExportable", (String)sampled);
            MDC.put((String)LEGACY_EXPORTABLE_NAME, (String)sampled);
            this.log("Starting scope for span: {}", currentSpan);
            if (currentSpan.parentId() != null && log.isTraceEnabled()) {
                log.trace("With parent: {}", (Object)currentSpan.parentId());
            }
            this.whitelistedBaggageKeysWithValue(currentSpan).forEach(s -> MDC.put((String)s, (String)ExtraFieldPropagation.get((TraceContext)currentSpan, (String)s)));
            this.whitelistedPropagationKeysWithValue(currentSpan).forEach(s -> MDC.put((String)s, (String)ExtraFieldPropagation.get((TraceContext)currentSpan, (String)s)));
        } else {
            MDC.remove((String)"traceId");
            MDC.remove((String)"parentId");
            MDC.remove((String)"spanId");
            MDC.remove((String)"spanExportable");
            MDC.remove((String)LEGACY_TRACE_ID_NAME);
            MDC.remove((String)LEGACY_PARENT_ID_NAME);
            MDC.remove((String)LEGACY_SPAN_ID_NAME);
            MDC.remove((String)LEGACY_EXPORTABLE_NAME);
            this.whitelistedBaggageKeys().forEach(MDC::remove);
            this.whitelistedPropagationKeys().forEach(MDC::remove);
        }
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            public void close() {
                Slf4jScopeDecorator.this.log("Closing scope for span: {}", currentSpan);
                scope.close();
                Slf4jScopeDecorator.replace("traceId", previousTraceId);
                Slf4jScopeDecorator.replace("parentId", previousParentId);
                Slf4jScopeDecorator.replace("spanId", previousSpanId);
                Slf4jScopeDecorator.replace("spanExportable", spanExportable);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_TRACE_ID_NAME, legacyPreviousTraceId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_PARENT_ID_NAME, legacyPreviousParentId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_SPAN_ID_NAME, legacyPreviousSpanId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_EXPORTABLE_NAME, legacySpanExportable);
                previousMdc.forEach(e -> Slf4jScopeDecorator.replace((String)e.getKey(), (String)e.getValue()));
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    private Stream<String> whitelistedBaggageKeys() {
        return this.sleuthProperties.getBaggageKeys().stream().filter(s -> this.sleuthSlf4jProperties.getWhitelistedMdcKeys().contains(s));
    }

    private Stream<String> whitelistedBaggageKeysWithValue(TraceContext context) {
        if (context == null) {
            return Stream.empty();
        }
        return this.whitelistedBaggageKeys().filter(s -> StringUtils.hasText((String)ExtraFieldPropagation.get((TraceContext)context, (String)s)));
    }

    private Stream<String> whitelistedPropagationKeys() {
        return this.sleuthProperties.getPropagationKeys().stream().filter(s -> this.sleuthSlf4jProperties.getWhitelistedMdcKeys().contains(s));
    }

    private Stream<String> whitelistedPropagationKeysWithValue(TraceContext context) {
        if (context == null) {
            return Stream.empty();
        }
        return this.whitelistedPropagationKeys().filter(s -> StringUtils.hasText((String)ExtraFieldPropagation.get((TraceContext)context, (String)s)));
    }

    private void log(String text, TraceContext span) {
        if (span == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace(text, (Object)span);
        }
    }

    static void replace(String key, @Nullable String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }
}

