/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.propagation;

import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.propagation.SleuthTagPropagationProperties;

public class TagPropagationFinishedSpanHandler
extends FinishedSpanHandler {
    private final SleuthProperties sleuthProperties;
    private final SleuthTagPropagationProperties tagPropagationProperties;

    public TagPropagationFinishedSpanHandler(SleuthProperties sleuthProperties, SleuthTagPropagationProperties tagPropagationProperties) {
        this.sleuthProperties = sleuthProperties;
        this.tagPropagationProperties = tagPropagationProperties;
    }

    public boolean handle(TraceContext context, MutableSpan span) {
        Stream.of(this.sleuthProperties.getBaggageKeys(), this.sleuthProperties.getPropagationKeys()).flatMap(Collection::stream).filter(key -> this.tagPropagationProperties.getWhitelistedKeys().contains(key)).map(baggageItemKey -> new AbstractMap.SimpleEntry<String, String>((String)baggageItemKey, ExtraFieldPropagation.get((TraceContext)context, (String)baggageItemKey))).filter(entry -> Objects.nonNull(entry.getValue())).forEach(entry -> span.tag((String)entry.getKey(), (String)entry.getValue()));
        return true;
    }
}

