/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.sampler;

import brave.sampler.Sampler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.sleuth.sampler.ProbabilityBasedSampler;
import org.springframework.cloud.sleuth.sampler.RateLimitingSampler;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SamplerProperties.class})
public class SamplerAutoConfiguration {
    static Sampler samplerFromProps(SamplerProperties config) {
        if (config.getRate() != null) {
            return new RateLimitingSampler(config);
        }
        return new ProbabilityBasedSampler(config);
    }

    @Configuration
    @ConditionalOnMissingBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class NonRefreshScopeSamplerConfiguration {
        protected NonRefreshScopeSamplerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return SamplerAutoConfiguration.samplerFromProps(config);
        }
    }

    @Configuration
    @ConditionalOnBean(type={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class RefreshScopedSamplerConfiguration {
        protected RefreshScopedSamplerConfiguration() {
        }

        @Bean
        @RefreshScope
        @ConditionalOnMissingBean
        public Sampler defaultTraceSampler(SamplerProperties config) {
            return SamplerAutoConfiguration.samplerFromProps(config);
        }
    }
}

