/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import brave.Tracing;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.instrument.async.ContextUtil;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class LazyTraceThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Log log = LogFactory.getLog(LazyTraceThreadPoolTaskExecutor.class);
    private final BeanFactory beanFactory;
    private final ThreadPoolTaskExecutor delegate;
    private Tracing tracing;
    private SpanNamer spanNamer;

    public LazyTraceThreadPoolTaskExecutor(BeanFactory beanFactory, ThreadPoolTaskExecutor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void execute(Runnable task) {
        this.delegate.execute(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceRunnable(this.tracing(), this.spanNamer(), task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceRunnable(this.tracing(), this.spanNamer(), task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceRunnable(this.tracing(), this.spanNamer(), task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit((Callable)(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceCallable(this.tracing(), this.spanNamer(), task)));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceRunnable(this.tracing(), this.spanNamer(), task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable((Callable)(ContextUtil.isContextInCreation(this.beanFactory) ? task : new TraceCallable(this.tracing(), this.spanNamer(), task)));
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.delegate.setThreadFactory(threadFactory);
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.delegate.setRejectedExecutionHandler(rejectedExecutionHandler);
    }

    public void setWaitForTasksToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.delegate.setWaitForTasksToCompleteOnShutdown(waitForJobsToCompleteOnShutdown);
    }

    public void setAwaitTerminationSeconds(int awaitTerminationSeconds) {
        this.delegate.setAwaitTerminationSeconds(awaitTerminationSeconds);
    }

    public void setBeanName(String name) {
        this.delegate.setBeanName(name);
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        return this.delegate.getThreadPoolExecutor();
    }

    public int getPoolSize() {
        return this.delegate.getPoolSize();
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public void destroy() {
        this.delegate.destroy();
        super.destroy();
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
        super.afterPropertiesSet();
    }

    public void initialize() {
        this.delegate.initialize();
    }

    public void shutdown() {
        this.delegate.shutdown();
        super.shutdown();
    }

    public Thread newThread(Runnable runnable) {
        return this.delegate.newThread(runnable);
    }

    public String getThreadNamePrefix() {
        return this.delegate.getThreadNamePrefix();
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.delegate.setThreadNamePrefix(threadNamePrefix);
    }

    public int getThreadPriority() {
        return this.delegate.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.delegate.setThreadPriority(threadPriority);
    }

    public boolean isDaemon() {
        return this.delegate.isDaemon();
    }

    public void setDaemon(boolean daemon) {
        this.delegate.setDaemon(daemon);
    }

    public void setThreadGroupName(String name) {
        this.delegate.setThreadGroupName(name);
    }

    public ThreadGroup getThreadGroup() {
        return this.delegate.getThreadGroup();
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.delegate.setThreadGroup(threadGroup);
    }

    public Thread createThread(Runnable runnable) {
        return this.delegate.createThread(runnable);
    }

    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.delegate.setCorePoolSize(corePoolSize);
    }

    public int getMaxPoolSize() {
        return this.delegate.getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.delegate.setMaxPoolSize(maxPoolSize);
    }

    public int getKeepAliveSeconds() {
        return this.delegate.getKeepAliveSeconds();
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.delegate.setKeepAliveSeconds(keepAliveSeconds);
    }

    public void setQueueCapacity(int queueCapacity) {
        this.delegate.setQueueCapacity(queueCapacity);
    }

    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.delegate.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.delegate.setTaskDecorator(taskDecorator);
    }

    private Tracing tracing() {
        if (this.tracing == null) {
            this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
        }
        return this.tracing;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

