/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Tracing;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.sleuth.instrument.reactor.HookRegisteringBeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.instrument.reactor.HooksRefresher;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthReactorProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceWebFluxAutoConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.reactor.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Mono.class})
@AutoConfigureAfter(value={TraceWebFluxAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthReactorProperties.class})
public class TraceReactorAutoConfiguration {
    static final String SLEUTH_REACTOR_EXECUTOR_SERVICE_KEY = "sleuth";

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={Tracing.class})
    static class TraceReactorConfiguration {
        static final String SLEUTH_TRACE_REACTOR_KEY = TraceReactorConfiguration.class.getName();
        private static final Log log = LogFactory.getLog(TraceReactorConfiguration.class);
        @Autowired
        BeanFactory beanFactory;

        TraceReactorConfiguration() {
        }

        @PreDestroy
        public void cleanupHooks() {
            SleuthReactorProperties reactorProperties;
            if (log.isTraceEnabled()) {
                log.trace((Object)"Cleaning up hooks");
            }
            if ((reactorProperties = (SleuthReactorProperties)this.beanFactory.getBean(SleuthReactorProperties.class)).isDecorateOnEach()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Resetting onEach operator instrumentation");
                }
                Hooks.resetOnEachOperator((String)SLEUTH_TRACE_REACTOR_KEY);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Resetting onLast operator instrumentation");
                }
                Hooks.resetOnLastOperator((String)SLEUTH_TRACE_REACTOR_KEY);
            }
            Schedulers.removeExecutorServiceDecorator((String)TraceReactorAutoConfiguration.SLEUTH_REACTOR_EXECUTOR_SERVICE_KEY);
        }

        @Bean
        @ConditionalOnMissingBean
        static HookRegisteringBeanDefinitionRegistryPostProcessor traceHookRegisteringBeanDefinitionRegistryPostProcessor(ConfigurableApplicationContext context) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Registering bean definition registry post processor for context [" + context + "]"));
            }
            return new HookRegisteringBeanDefinitionRegistryPostProcessor(context);
        }

        @Configuration
        @ConditionalOnClass(value={RefreshScope.class})
        static class HooksRefresherConfiguration {
            HooksRefresherConfiguration() {
            }

            @Bean
            HooksRefresher hooksRefresher(SleuthReactorProperties reactorProperties, ConfigurableApplicationContext context) {
                return new HooksRefresher(reactorProperties, context);
            }
        }
    }
}

