/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.provisioning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.DeclarationExceptionEvent;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RabbitExchangeQueueProvisioner
implements ApplicationListener<DeclarationExceptionEvent>,
ProvisioningProvider<ExtendedConsumerProperties<RabbitConsumerProperties>, ExtendedProducerProperties<RabbitProducerProperties>> {
    private static final String GROUP_INDEX_DELIMITER = ".";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RabbitAdmin rabbitAdmin;
    private boolean notOurAdminException;
    private final GenericApplicationContext autoDeclareContext = new GenericApplicationContext();
    private final List<DeclarableCustomizer> customizers;

    public RabbitExchangeQueueProvisioner(ConnectionFactory connectionFactory) {
        this(connectionFactory, Collections.emptyList());
    }

    public RabbitExchangeQueueProvisioner(ConnectionFactory connectionFactory, List<DeclarableCustomizer> customizers) {
        this.rabbitAdmin = new RabbitAdmin(connectionFactory);
        this.autoDeclareContext.refresh();
        this.rabbitAdmin.setApplicationContext((ApplicationContext)this.autoDeclareContext);
        this.rabbitAdmin.afterPropertiesSet();
        this.customizers = customizers;
    }

    public ProducerDestination provisionProducerDestination(String name, ExtendedProducerProperties<RabbitProducerProperties> producerProperties) {
        String exchangeName = RabbitExchangeQueueProvisioner.applyPrefix(((RabbitProducerProperties)producerProperties.getExtension()).getPrefix(), name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)producerProperties.getExtension(), exchangeName);
        if (((RabbitProducerProperties)producerProperties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        Binding binding = null;
        for (String requiredGroupName : producerProperties.getRequiredGroups()) {
            String baseQueueName;
            String string = baseQueueName = ((RabbitProducerProperties)producerProperties.getExtension()).isQueueNameGroupOnly() ? requiredGroupName : exchangeName + GROUP_INDEX_DELIMITER + requiredGroupName;
            if (!producerProperties.isPartitioned()) {
                this.autoBindDLQ(baseQueueName, baseQueueName, (RabbitCommonProperties)producerProperties.getExtension());
                if (!((RabbitProducerProperties)producerProperties.getExtension()).isBindQueue()) continue;
                Queue queue = new Queue(baseQueueName, true, false, false, this.queueArgs(baseQueueName, (RabbitCommonProperties)producerProperties.getExtension(), false));
                this.declareQueue(baseQueueName, queue);
                Object[] routingKeys = this.bindingRoutingKeys((RabbitCommonProperties)producerProperties.getExtension());
                if (ObjectUtils.isEmpty((Object[])routingKeys)) {
                    binding = this.notPartitionedBinding(exchange, queue, null, (RabbitCommonProperties)producerProperties.getExtension());
                    continue;
                }
                for (Object routingKey : routingKeys) {
                    binding = this.notPartitionedBinding(exchange, queue, (String)routingKey, (RabbitCommonProperties)producerProperties.getExtension());
                }
                continue;
            }
            for (int i = 0; i < producerProperties.getPartitionCount(); ++i) {
                String partitionSuffix = "-" + i;
                String partitionQueueName = baseQueueName + partitionSuffix;
                this.autoBindDLQ(baseQueueName, baseQueueName + partitionSuffix, (RabbitCommonProperties)producerProperties.getExtension());
                if (!((RabbitProducerProperties)producerProperties.getExtension()).isBindQueue()) continue;
                Queue queue = new Queue(partitionQueueName, true, false, false, this.queueArgs(partitionQueueName, (RabbitCommonProperties)producerProperties.getExtension(), false));
                this.declareQueue(queue.getName(), queue);
                String prefix = ((RabbitProducerProperties)producerProperties.getExtension()).getPrefix();
                String destination = StringUtils.isEmpty((Object)prefix) ? exchangeName : exchangeName.substring(prefix.length());
                Object[] routingKeys = this.bindingRoutingKeys((RabbitCommonProperties)producerProperties.getExtension());
                if (ObjectUtils.isEmpty((Object[])routingKeys)) {
                    binding = this.partitionedBinding(destination, exchange, queue, null, (RabbitCommonProperties)producerProperties.getExtension(), i);
                    continue;
                }
                for (Object routingKey : routingKeys) {
                    binding = this.partitionedBinding(destination, exchange, queue, (String)routingKey, (RabbitCommonProperties)producerProperties.getExtension(), i);
                }
            }
        }
        return new RabbitProducerDestination(exchange, binding);
    }

    public ConsumerDestination provisionConsumerDestination(String name, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        ConsumerDestination consumerDestination;
        if (!properties.isMultiplex()) {
            consumerDestination = this.doProvisionConsumerDestination(name, group, properties);
        } else {
            Object[] provisionedDestinations = (String[])Stream.of(StringUtils.tokenizeToStringArray((String)name, (String)",", (boolean)true, (boolean)true)).flatMap(destination -> {
                if (properties.isPartitioned() && !ObjectUtils.isEmpty((Object)properties.getInstanceIndexList())) {
                    ArrayList<String> consumerDestinationNames = new ArrayList<String>();
                    for (Integer index : properties.getInstanceIndexList()) {
                        ExtendedConsumerProperties temporaryProperties = new ExtendedConsumerProperties(properties.getExtension());
                        BeanUtils.copyProperties((Object)properties, (Object)temporaryProperties);
                        temporaryProperties.setInstanceIndex(index.intValue());
                        consumerDestinationNames.add(this.doProvisionConsumerDestination((String)destination, group, (ExtendedConsumerProperties<RabbitConsumerProperties>)temporaryProperties).getName());
                    }
                    return consumerDestinationNames.stream();
                }
                return Stream.of(this.doProvisionConsumerDestination((String)destination, group, properties).getName());
            }).toArray(String[]::new);
            consumerDestination = new RabbitConsumerDestination(StringUtils.arrayToCommaDelimitedString((Object[])provisionedDestinations), null);
        }
        return consumerDestination;
    }

    private ConsumerDestination doProvisionConsumerDestination(String name, String group, ExtendedConsumerProperties<RabbitConsumerProperties> properties) {
        AnonymousQueue queue;
        boolean durable;
        boolean anonymous = !StringUtils.hasText((String)group);
        Base64UrlNamingStrategy anonQueueNameGenerator = null;
        if (anonymous) {
            anonQueueNameGenerator = new Base64UrlNamingStrategy(((RabbitConsumerProperties)properties.getExtension()).getAnonymousGroupPrefix() == null ? "" : ((RabbitConsumerProperties)properties.getExtension()).getAnonymousGroupPrefix());
        }
        String baseQueueName = ((RabbitConsumerProperties)properties.getExtension()).isQueueNameGroupOnly() ? (anonymous ? anonQueueNameGenerator.generateName() : group) : this.groupedName(name, anonymous ? anonQueueNameGenerator.generateName() : group);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("declaring queue for inbound: " + baseQueueName + ", bound to: " + name));
        }
        String prefix = ((RabbitConsumerProperties)properties.getExtension()).getPrefix();
        String exchangeName = RabbitExchangeQueueProvisioner.applyPrefix(prefix, name);
        Exchange exchange = this.buildExchange((RabbitCommonProperties)properties.getExtension(), exchangeName);
        if (((RabbitConsumerProperties)properties.getExtension()).isDeclareExchange()) {
            this.declareExchange(exchangeName, exchange);
        }
        String queueName = RabbitExchangeQueueProvisioner.applyPrefix(prefix, baseQueueName);
        boolean partitioned = !anonymous && properties.isPartitioned();
        boolean bl = durable = !anonymous && ((RabbitConsumerProperties)properties.getExtension()).isDurableSubscription();
        if (anonymous) {
            String anonQueueName = queueName;
            queue = new AnonymousQueue(() -> anonQueueName, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false));
        } else {
            if (partitioned) {
                String partitionSuffix = "-" + properties.getInstanceIndex();
                queueName = queueName + partitionSuffix;
            }
            queue = durable ? new Queue(queueName, true, false, false, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false)) : new Queue(queueName, false, false, true, this.queueArgs(queueName, (RabbitCommonProperties)properties.getExtension(), false));
        }
        Binding binding = null;
        if (((RabbitConsumerProperties)properties.getExtension()).isBindQueue()) {
            this.declareQueue(queueName, (Queue)queue);
            Object[] routingKeys = this.bindingRoutingKeys((RabbitCommonProperties)properties.getExtension());
            if (ObjectUtils.isEmpty((Object[])routingKeys)) {
                binding = this.declareConsumerBindings(name, null, properties, exchange, partitioned, (Queue)queue);
            } else {
                for (Object routingKey : routingKeys) {
                    binding = this.declareConsumerBindings(name, (String)routingKey, properties, exchange, partitioned, (Queue)queue);
                }
            }
        }
        if (durable) {
            this.autoBindDLQ(RabbitExchangeQueueProvisioner.applyPrefix(((RabbitConsumerProperties)properties.getExtension()).getPrefix(), baseQueueName), queueName, (RabbitCommonProperties)properties.getExtension());
        }
        return new RabbitConsumerDestination(queue.getName(), binding);
    }

    protected final String groupedName(String name, String group) {
        return name + GROUP_INDEX_DELIMITER + (StringUtils.hasText((String)group) ? group : "default");
    }

    private Binding declareConsumerBindings(String name, String routingKey, ExtendedConsumerProperties<RabbitConsumerProperties> properties, Exchange exchange, boolean partitioned, Queue queue) {
        if (partitioned) {
            return this.partitionedBinding(name, exchange, queue, routingKey, (RabbitCommonProperties)properties.getExtension(), properties.getInstanceIndex());
        }
        return this.notPartitionedBinding(exchange, queue, routingKey, (RabbitCommonProperties)properties.getExtension());
    }

    private Binding partitionedBinding(String destination, Exchange exchange, Queue queue, String rk, RabbitCommonProperties extendedProperties, int index) {
        String bindingKey = rk;
        if (bindingKey == null) {
            bindingKey = destination;
        }
        bindingKey = bindingKey + "-" + index;
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.putAll(extendedProperties.getQueueBindingArguments());
        if (exchange instanceof TopicExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(bindingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof DirectExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(bindingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof FanoutExchange) {
            throw new ProvisioningException("A fanout exchange is not appropriate for partitioned apps");
        }
        if (exchange instanceof HeadersExchange) {
            Binding binding = new Binding(queue.getName(), Binding.DestinationType.QUEUE, exchange.getName(), "", arguments);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        throw new ProvisioningException("Cannot bind to a " + exchange.getType() + " exchange");
    }

    private Binding notPartitionedBinding(Exchange exchange, Queue queue, String rk, RabbitCommonProperties extendedProperties) {
        String routingKey = rk;
        if (routingKey == null) {
            routingKey = "#";
        }
        HashMap<String, String> arguments = new HashMap<String, String>(extendedProperties.getQueueBindingArguments());
        if (exchange instanceof TopicExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((TopicExchange)exchange).with(routingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof DirectExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((DirectExchange)exchange).with(routingKey);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof FanoutExchange) {
            Binding binding = BindingBuilder.bind((Queue)queue).to((FanoutExchange)exchange);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        if (exchange instanceof HeadersExchange) {
            Binding binding = new Binding(queue.getName(), Binding.DestinationType.QUEUE, exchange.getName(), "", arguments);
            this.declareBinding(queue.getName(), binding);
            return binding;
        }
        throw new ProvisioningException("Cannot bind to a " + exchange.getType() + " exchange");
    }

    private String[] bindingRoutingKeys(RabbitCommonProperties extendedProperties) {
        return StringUtils.delimitedListToStringArray((String)extendedProperties.getBindingRoutingKey(), (String)extendedProperties.getBindingRoutingKeyDelimiter());
    }

    private void autoBindDLQ(String baseQueueName, String routingKey, RabbitCommonProperties properties) {
        boolean autoBindDlq = properties.isAutoBindDlq();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("autoBindDLQ=" + autoBindDlq + " for: " + baseQueueName));
        }
        if (autoBindDlq) {
            String dlqName = properties.getDeadLetterQueueName() == null ? RabbitExchangeQueueProvisioner.constructDLQName(baseQueueName) : properties.getDeadLetterQueueName();
            Queue dlq = new Queue(dlqName, true, false, false, this.queueArgs(dlqName, properties, true));
            this.declareQueue(dlqName, dlq);
            String dlxName = this.deadLetterExchangeName(properties);
            if (properties.isDeclareDlx()) {
                this.declareExchange(dlxName, new ExchangeBuilder(dlxName, properties.getDeadLetterExchangeType()).durable(true).build());
            }
            HashMap<String, String> arguments = new HashMap<String, String>(properties.getDlqBindingArguments());
            Binding dlqBinding = new Binding(dlq.getName(), Binding.DestinationType.QUEUE, dlxName, properties.getDeadLetterRoutingKey() == null ? routingKey : properties.getDeadLetterRoutingKey(), arguments);
            this.declareBinding(dlqName, dlqBinding);
            if (properties instanceof RabbitConsumerProperties && ((RabbitConsumerProperties)properties).isRepublishToDlq()) {
                this.declareBinding(dlqName, new Binding(dlq.getName(), Binding.DestinationType.QUEUE, dlxName, baseQueueName, arguments));
            }
        }
    }

    public static String constructDLQName(String name) {
        return name + ".dlq";
    }

    private String deadLetterExchangeName(RabbitCommonProperties properties) {
        if (properties.getDeadLetterExchange() == null) {
            return properties.getPrefix() + "DLX";
        }
        return properties.getDeadLetterExchange();
    }

    private void declareQueue(String beanName, Queue queueArg) {
        Queue queue;
        block6: {
            queue = queueArg;
            for (DeclarableCustomizer customizer : this.customizers) {
                queue = (Queue)customizer.apply((Object)queue);
            }
            try {
                this.rabbitAdmin.declareQueue(queue);
            }
            catch (AmqpConnectException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Declaration of queue: " + queue.getName() + " deferred - connection not available"));
                }
            }
            catch (RuntimeException e) {
                if (this.notOurAdminException) {
                    this.notOurAdminException = false;
                    throw e;
                }
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Declaration of queue: " + queue.getName() + " deferred"), (Throwable)e);
            }
        }
        this.addToAutoDeclareContext(beanName, queue);
    }

    private Map<String, Object> queueArgs(String queueName, RabbitCommonProperties properties, boolean isDlq) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (!isDlq) {
            if (properties.isAutoBindDlq()) {
                String dlx = properties.getDeadLetterExchange() != null ? properties.getDeadLetterExchange() : RabbitExchangeQueueProvisioner.applyPrefix(properties.getPrefix(), "DLX");
                args.put("x-dead-letter-exchange", dlx);
                String dlRk = properties.getDeadLetterRoutingKey() != null ? properties.getDeadLetterRoutingKey() : queueName;
                args.put("x-dead-letter-routing-key", dlRk);
            }
        } else {
            if (properties.getDlqDeadLetterExchange() != null) {
                args.put("x-dead-letter-exchange", properties.getDlqDeadLetterExchange());
            }
            if (properties.getDlqDeadLetterRoutingKey() != null) {
                args.put("x-dead-letter-routing-key", properties.getDlqDeadLetterRoutingKey());
            }
        }
        this.additionalArgs(args, properties, isDlq);
        return args;
    }

    private void additionalArgs(Map<String, Object> args, RabbitCommonProperties properties, boolean isDlq) {
        boolean singleActive;
        Integer expires = isDlq ? properties.getDlqExpires() : properties.getExpires();
        Integer maxLength = isDlq ? properties.getDlqMaxLength() : properties.getMaxLength();
        Integer maxLengthBytes = isDlq ? properties.getDlqMaxLengthBytes() : properties.getMaxLengthBytes();
        Integer maxPriority = isDlq ? properties.getDlqMaxPriority() : properties.getMaxPriority();
        Integer ttl = isDlq ? properties.getDlqTtl() : properties.getTtl();
        boolean lazy = isDlq ? properties.isDlqLazy() : properties.isLazy();
        String overflow = isDlq ? properties.getDlqOverflowBehavior() : properties.getOverflowBehavior();
        RabbitCommonProperties.QuorumConfig quorum = isDlq ? properties.getDlqQuorum() : properties.getQuorum();
        boolean bl = singleActive = isDlq ? properties.isDlqSingleActiveConsumer() : properties.isSingleActiveConsumer();
        if (expires != null) {
            args.put("x-expires", expires);
        }
        if (maxLength != null) {
            args.put("x-max-length", maxLength);
        }
        if (maxLengthBytes != null) {
            args.put("x-max-length-bytes", maxLengthBytes);
        }
        if (maxPriority != null) {
            args.put("x-max-priority", maxPriority);
        }
        if (ttl != null) {
            args.put("x-message-ttl", ttl);
        }
        if (lazy) {
            args.put("x-queue-mode", "lazy");
        }
        if (StringUtils.hasText((String)overflow)) {
            args.put("x-overflow", overflow);
        }
        if (quorum != null && quorum.isEnabled()) {
            args.put("x-queue-type", "quorum");
            if (quorum.getDeliveryLimit() != null) {
                args.put("x-delivery-limit", quorum.getDeliveryLimit());
            }
            if (quorum.getInitialGroupSize() != null) {
                args.put("x-quorum-initial-group-size", quorum.getInitialGroupSize());
            }
        }
        if (singleActive) {
            args.put("x-single-active-consumer", true);
        }
    }

    public static String applyPrefix(String prefix, String name) {
        return prefix + name;
    }

    private Exchange buildExchange(RabbitCommonProperties properties, String exchangeName) {
        try {
            ExchangeBuilder builder = new ExchangeBuilder(exchangeName, properties.getExchangeType());
            builder.durable(properties.isExchangeDurable());
            if (properties.isExchangeAutoDelete()) {
                builder.autoDelete();
            }
            if (properties.isDelayedExchange()) {
                builder.delayed();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to create exchange object", (Throwable)e);
        }
    }

    private void declareExchange(String rootName, Exchange exchangeArg) {
        Exchange exchange;
        block6: {
            exchange = exchangeArg;
            for (DeclarableCustomizer customizer : this.customizers) {
                exchange = (Exchange)customizer.apply((Object)exchange);
            }
            try {
                this.rabbitAdmin.declareExchange(exchange);
            }
            catch (AmqpConnectException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Declaration of exchange: " + exchange.getName() + " deferred - connection not available"));
                }
            }
            catch (RuntimeException e) {
                if (this.notOurAdminException) {
                    this.notOurAdminException = false;
                    throw e;
                }
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Declaration of exchange: " + exchange.getName() + " deferred"), (Throwable)e);
            }
        }
        this.addToAutoDeclareContext(rootName + ".exchange", exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToAutoDeclareContext(String name, Object bean) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            if (!this.autoDeclareContext.containsBean(name)) {
                this.autoDeclareContext.getBeanFactory().registerSingleton(name, bean);
            }
        }
    }

    private void declareBinding(String rootName, Binding bindingArg) {
        Binding binding;
        block6: {
            binding = bindingArg;
            for (DeclarableCustomizer customizer : this.customizers) {
                binding = (Binding)customizer.apply((Object)binding);
            }
            try {
                this.rabbitAdmin.declareBinding(binding);
            }
            catch (AmqpConnectException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Declaration of binding: " + rootName + ".binding deferred - connection not available"));
                }
            }
            catch (RuntimeException e) {
                if (this.notOurAdminException) {
                    this.notOurAdminException = false;
                    throw e;
                }
                if (!this.logger.isDebugEnabled()) break block6;
                this.logger.debug((Object)("Declaration of binding: " + rootName + ".binding deferred"), (Throwable)e);
            }
        }
        this.addToAutoDeclareContext(rootName + ".binding", binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAutoDeclareContext(ConsumerDestination destination, ExtendedConsumerProperties<RabbitConsumerProperties> consumerProperties) {
        GenericApplicationContext genericApplicationContext = this.autoDeclareContext;
        synchronized (genericApplicationContext) {
            Stream.of(StringUtils.tokenizeToStringArray((String)destination.getName(), (String)",", (boolean)true, (boolean)true)).forEach(name -> {
                name = name.trim();
                this.removeSingleton(name + ".binding");
                this.removeSingleton((String)name);
                String dlq = name + ".dlq";
                this.removeSingleton(dlq + ".binding");
                this.removeSingleton(dlq);
            });
        }
    }

    private void removeSingleton(String name) {
        ConfigurableListableBeanFactory beanFactory;
        if (this.autoDeclareContext.containsBean(name) && (beanFactory = this.autoDeclareContext.getBeanFactory()) instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)beanFactory).destroySingleton(name);
        }
    }

    public void onApplicationEvent(DeclarationExceptionEvent event) {
        this.notOurAdminException = true;
    }

    private static final class RabbitConsumerDestination
    implements ConsumerDestination {
        private final String queue;
        private final Binding binding;

        RabbitConsumerDestination(String queue, Binding binding) {
            Assert.notNull((Object)queue, (String)"queue must not be null");
            this.queue = queue;
            this.binding = binding;
        }

        public String toString() {
            return "RabbitConsumerDestination{queue=" + this.queue + ", binding=" + this.binding + '}';
        }

        public String getName() {
            return this.queue;
        }
    }

    private static final class RabbitProducerDestination
    implements ProducerDestination {
        private final Exchange exchange;
        private final Binding binding;

        RabbitProducerDestination(Exchange exchange, Binding binding) {
            Assert.notNull((Object)exchange, (String)"exchange must not be null");
            this.exchange = exchange;
            this.binding = binding;
        }

        public String getName() {
            return this.exchange.getName();
        }

        public String getNameForPartition(int partition) {
            return this.exchange.getName();
        }

        public String toString() {
            return "RabbitProducerDestination{exchange=" + this.exchange + ", binding=" + this.binding + '}';
        }
    }
}

